% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-session-info.R
\name{btw_tool_session_package_info}
\alias{btw_tool_session_package_info}
\title{Tool: Gather information about a package or currently loaded packages}
\usage{
btw_tool_session_package_info(
  packages = "attached",
  dependencies = "",
  `_intent` = ""
)
}
\arguments{
\item{packages}{Which packages to show, or \code{"loaded"} to show all loaded
packages, \code{"attached"} to show all attached packages, or \code{"installed"} to
show all installed packages.}

\item{dependencies}{Whether to include the dependencies when listing package
information.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
Returns a string describing the selected packages.
}
\description{
Uses \code{\link[sessioninfo:package_info]{sessioninfo::package_info()}} to provide information about the loaded,
attached, or installed packages. The primary use case is to verify that a
package is installed; check the version number of a specific packages; or
determine which packages are already in use in a session.
}
\examples{
btw_tool_session_package_info("btw")

}
\seealso{
\code{\link[=btw_tools]{btw_tools()}}, \code{\link[=btw_tool_session_platform_info]{btw_tool_session_platform_info()}}

Other session tools: 
\code{\link{btw_tool_session_check_package_installed}()},
\code{\link{btw_tool_session_platform_info}()}
}
\concept{session tools}
