% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/digital-ocean.R
\name{do_forward}
\alias{do_forward}
\title{Forward root requests to an application}
\usage{
do_forward(droplet, path, ...)
}
\arguments{
\item{droplet}{The droplet on which to act.}

\item{path}{The application path to forward root requests to.}

\item{...}{additional arguments to pass to \code{\link[analogsea:droplet_ssh]{analogsea::droplet_ssh()}}.}
}
\value{
The DigitalOcean droplet
}
\description{
Configures nginx to forward requests from the root path (/) to a specific application.
}
\examples{
\dontrun{
  droplet <- analogsea::droplet(123456)

  # Forward root URL to an application
  do_forward(droplet, "myapp")

  # Now visiting http://your-ip/ will redirect to http://your-ip/myapp
}
}
