% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\docType{data}
\name{results}
\alias{results}
\title{IACGMOOH voting results data}
\format{
\subsection{\code{results}}{

A data frame with 2,611 rows and 7 columns:
\describe{
\item{season}{(\emph{numeric}) Season of the show}
\item{day}{(\emph{numeric}) Day of the vote (i.e. number of days after the season started)}
\item{vote}{(\emph{numeric}) Number of the vote (i.e. 1 = the first vote of the season,
2 = second vote of the season, etc. - useful for situations like the final where there are
two votes on the same day.)}
\item{contestant}{(\emph{character}) First name of a celebrity contestant competing in the vote}
\item{result}{(\emph{character}) One of: 'safe' if the celebrity was NOT eliminated, 'eliminated' if they WERE
eliminated, or NA if they did not take part (i.e. had been eliminated or withdrew in an earlier vote)}
\item{position}{(\emph{numeric}) Where it is known, their position in this vote (i.e. 1 = received the most
votes, 2 = second-most votes etc.)}
\item{vote_share}{(\emph{numeric}) Where it is known, the proportion of all votes the celebrity received}
}
}
}
\source{
\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_1}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_2}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_3}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_4}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_5}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_6}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_7}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_8}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_9}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_10}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_11}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_12}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_13}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_14}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_15}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_16}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_17}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_18}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_19}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_20}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_21}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_22}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_23}

\url{https://en.wikipedia.org/wiki/I\%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_24}
}
\usage{
results
}
\description{
Data on each of the viewer votes in the first 24 seasons of the
UK TV show "I'm A Celebrity, Get Me Out Of Here"
}
\examples{
{
# How many times were contestants immune from being voted off
sum(results$result == "immune", na.rm = TRUE)
}
}
\keyword{datasets}
