% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regularly.R
\name{regularly}
\alias{regularly}
\title{Generate list of repeating financial transactions}
\usage{
regularly(
  years,
  pa,
  month = "01",
  last = 0,
  first = 0,
  merge = list(),
  digits = 2
)
}
\arguments{
\item{years}{Integer vector, the range of years to cover.}

\item{pa}{A vector with values for each year. This amounts to the total sum for the respective year.}

\item{month}{Character,
      but numeric description of a month in "MM" format when to account the values of \code{pa}.
If you provide more than a single month here, e.g., quarterly payments,
      the amounts defined by \code{pa} are
divided the number of months.}

\item{last}{Defines the final entry, last month of the last year. It can be either
a numeric value (taken as-is), \code{"rep"} (repeats the last value of pa),
or \code{"none"} to omit adding a last month (e.g.,
      to later merge with results of another call to this function).
Only used if month is not "12".}

\item{first}{Defines how to treat years if January was included in in \code{month}. This could be desired for merging,
but problematic if you want to create a new transaction object. Valid values are the same as for \code{last} except
\code{"rep"}.}

\item{merge}{Another list of values to be merged with the results,
      can be used for nested calls of this function to
generate more complex patterns.}

\item{digits}{Number of digits used for rounding when \code{month} is more than one entry.}
}
\value{
A list of monthly transactions named in "YYYY.MM" scheme (\code{regularly_delayed}).
}
\description{
For all years defined, generates a list of values as defined by \code{pa}
and due at the given month. The result can be used as input for the
\code{.list} argument of \code{\link[businessPlanR:expense]{expense}},
\code{\link[businessPlanR:revenue]{revenue}},
      and \code{\link[businessPlanR:transaction]{transaction}}.
}
\examples{
expense(
    type="Operation",
    category="Insurance",
    name="Electronics",
    missing="0",
    .list=regularly(
        years=2021:2025,
        pa=rep(111.11, 5),
        month="01",
        last=0
    )
)
}
