% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recall_data.R
\name{recall_by_model}
\alias{recall_by_model}
\title{Summary of recalls searching by model}
\usage{
recall_by_model(
  model,
  start_year = NULL,
  end_year = NULL,
  limit = 25,
  partial = TRUE,
  api_key = NULL
)
}
\arguments{
\item{model}{List of model names.}

\item{start_year}{Start of year range (optional).}

\item{end_year}{End of year range (optional).}

\item{limit}{Number indicating how many recall entries should be returned.
Defaults to 25 which is the default of the API.}

\item{partial}{Logical; if TRUE, returns all partial search term matches.}

\item{api_key}{API access key to use, if not set in environment.}
}
\value{
A tibble of recall summary information from the Vehicle Recalls
Database. Includes six columns.
}
\description{
Returns summary information of recalls in the Vehicle Recalls Database based
on a model search term.
}
\details{
Queries the Vehicle Recalls Database API by model and returns summary recall
information. The year range of the search can be specified and is based on
the manufactured year and not the year a recall occurred. Partial search
term matches can also be returned by the function and is the default. Note
that if \code{partial = FALSE} is used, the number of entries returned by the
function may be less than the count provided by
\code{\link{count_recall_by_model}} which returns a count for all partial
matches.

An API key is required to run the function and query the Vehicle Recalls
Database. The key can be acquired at
\url{https://tc.api.canada.ca/en/detail?api=VRDB}.

The API key can be set in the environment using
\code{Sys.setenv(VRD_API = 'your_API_key_here')} and will be used by the
function, or can be passed into the function using the \code{api_key}
argument.
}
\examples{
\dontrun{
recall_by_model("civic")
recall_by_model(c("RANGER RZR 800", "BRZ"), start_year = 2008, partial = FALSE)
API_KEY <- "xxxxxxxxxxx"
recall_by_model("RANGER", end_year = 2000, limit = 100, api_key = API_KEY)
}
}
