% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cacc.R
\name{cacc}
\alias{cacc}
\title{Conjunctive Analysis of Case Configurations}
\usage{
cacc(data, ivs, dv)
}
\arguments{
\item{data}{A data frame or a tibble.}

\item{ivs}{A vector of names of the independent variables, without quotes. Variables must be categorical, either integer, character, or factor.}

\item{dv}{Name of the dependent variable, without quotes. Variable must be a dichotomous integer or factor with values 0 (absence) and 1 (presence).}
}
\value{
Returns a tibble with the CACC matrix.
}
\description{
Computes a Conjunctive Analysis of Case Configurations (CACC).
}
\examples{
cacc(
  data = onharassment,
  ivs = c(sex, age, hours, snapchat, instagram, facebook, twitter, name, photos, privacy),
  dv = rep_victim
)
cacc(onharassment, ivs = sex:privacy, dv = rep_victim)

# Syntax with the native R pipe
onharassment |> cacc(ivs = sex:privacy, dv = rep_victim)
}
\references{
Miethe, T. D., Hart, T. C., & Regoeczi, W. C. (2008). The Conjunctive Analysis of Case Configurations: An Exploratory Method for Discrete Multivariate Analyses of Crime Data. \emph{Journal of Quantitative Criminology, 24}, 227–241. https://doi.org/10.1007/s10940-008-9044-8
}
