% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components-generated.R
\name{calcite_color_picker}
\alias{calcite_color_picker}
\title{Create a ColorPicker component}
\usage{
calcite_color_picker(...)
}
\arguments{
\item{...}{named attributes passed to \code{htmltools::tag()}}
}
\value{
an object of class \code{calcite_component} which is a subclass of \code{shiny.tag}
}
\description{
Create a ColorPicker component
}
\details{
\subsection{Properties}{

The following properties are provided by this component:\tabular{lllll}{
   Name \tab Attribute \tab Description \tab Values \tab Reflects to Attribute \cr
   allowEmpty \tab allow-empty \tab When \code{true}, an empty color (\code{null}) will be allowed as a \code{value}.  When \code{false}, a color value is enforced, and clearing the input or blurring will restore the last valid \code{value}. \tab boolean \tab TRUE \cr
   alphaChannel \tab alpha-channel \tab When \code{true}, the component will allow updates to the color's alpha value. \tab boolean \tab FALSE \cr
   channelsDisabled \tab channels-disabled \tab When \code{true}, hides the RGB/HSV channel inputs. \tab boolean \tab FALSE \cr
   clearable \tab clearable \tab When \code{true}, an empty color (\code{null}) will be allowed as a \code{value}.  When \code{false}, a color value is enforced, and clearing the input or blurring will restore the last valid \code{value}. \tab boolean \tab TRUE \cr
   disabled \tab disabled \tab When \code{true}, interaction is prevented and the component is displayed with lower opacity. \tab boolean \tab TRUE \cr
   format \tab format \tab The format of \code{value}.  When \code{"auto"}, the format will be inferred from \code{value} when set. \tab "auto" | "hex" | "hexa" | "hsl" | "hsl-css" | "hsla" | "hsla-css" | "hsv" | "hsva" | "rgb" | "rgb-css" | "rgba" | "rgba-css" \tab TRUE \cr
   hexDisabled \tab hex-disabled \tab When \code{true}, hides the hex input. \tab boolean \tab FALSE \cr
   messageOverrides \tab NA \tab Use this property to override individual strings used by the component. \tab Check API reference \tab FALSE \cr
   numberingSystem \tab numbering-system \tab Specifies the Unicode numeral system used by the component for localization. \tab "arab" | "arabext" | "latn" \tab TRUE \cr
   savedDisabled \tab saved-disabled \tab When \code{true}, hides the saved colors section. \tab boolean \tab TRUE \cr
   scale \tab scale \tab Specifies the size of the component. \tab "l" | "m" | "s" \tab TRUE \cr
   storageId \tab storage-id \tab Specifies the storage ID for colors. \tab string \tab TRUE \cr
   value \tab value \tab The component's value, where the value can be a CSS color string, or a RGB, HSL or HSV object.  The type will be preserved as the color is updated. \tab (HSL & ObjectWithAlpha) | (HSV & ObjectWithAlpha) | (RGB & ObjectWithAlpha) | HSL | HSV | RGB | string \tab FALSE \cr
}

}

\subsection{Events}{

The following events are observed by shiny:\tabular{ll}{
   Event \tab Description \cr
   calciteColorPickerChange \tab Fires when the color value has changed. \cr
   calciteColorPickerInput \tab Fires as the color value changes. Similar to the \code{calciteColorPickerChange} event with the exception of dragging. When dragging the color field or hue slider thumb, this event fires as the thumb is moved. \cr
}

}
}
\examples{
calcite_color_picker()
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/color-picker/}{Official Documentation}
}
