% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components-generated.R
\name{calcite_tile_select}
\alias{calcite_tile_select}
\title{Create a TileSelect component}
\usage{
calcite_tile_select(...)
}
\arguments{
\item{...}{named attributes passed to \code{htmltools::tag()}}
}
\value{
an object of class \code{calcite_component} which is a subclass of \code{shiny.tag}
}
\description{
Use the \code{calcite-tile} component instead.
}
\details{
\subsection{Properties}{

The following properties are provided by this component:\tabular{lllll}{
   Name \tab Attribute \tab Description \tab Values \tab Reflects to Attribute \cr
   checked \tab checked \tab When \code{true}, the component is checked. \tab boolean \tab TRUE \cr
   description \tab description \tab A description for the component, which displays below the heading. \tab string \tab TRUE \cr
   disabled \tab disabled \tab When \code{true}, interaction is prevented and the component is displayed with lower opacity. \tab boolean \tab TRUE \cr
   heading \tab heading \tab The component header text, which displays between the icon and description. \tab string \tab TRUE \cr
   icon \tab icon \tab Specifies an icon to display. \tab string \tab TRUE \cr
   iconFlipRtl \tab icon-flip-rtl \tab When \code{true}, the icon will be flipped when the element direction is right-to-left (\code{"rtl"}). \tab boolean \tab TRUE \cr
   inputAlignment \tab input-alignment \tab When \code{inputEnabled} is \code{true}, specifies the placement of the interactive input on the component. \tab "end" | "start" \tab TRUE \cr
   inputEnabled \tab input-enabled \tab When \code{true}, displays an interactive input based on the \code{type} property. \tab boolean \tab TRUE \cr
   name \tab name \tab Specifies the name of the component on form submission. \tab any \tab TRUE \cr
   type \tab type \tab Specifies the selection mode of the component, where:  \code{"radio"} is for single selection, and  \code{"checkbox"} is for multiple selections. \tab "checkbox" | "radio" \tab TRUE \cr
   value \tab value \tab The component's value. \tab any \tab FALSE \cr
   width \tab width \tab Specifies the width of the component. \tab "auto" | "full" \tab TRUE \cr
}

}

\subsection{Events}{

The following events are observed by shiny:\tabular{ll}{
   Event \tab Description \cr
   calciteTileSelectChange \tab Emits a custom change event. For checkboxes it emits when checked or unchecked. For radios it only emits when checked. \cr
}

}

\subsection{Slots}{

The following slots are provided by this component:\tabular{ll}{
   Slot \tab Description \cr
   Default (unnamed) \tab A slot for adding custom content. \cr
}

}
}
\examples{
calcite_tile_select()
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/tile-select/}{Official Documentation}
}
