% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrar-main.R
\name{calibration_objFn}
\alias{calibration_objFn}
\title{Create an objective function to be used with optimization routines}
\usage{
calibration_objFn(model, setup, observed, aggFn = NULL, aggregate = FALSE, ...)
}
\arguments{
\item{model}{Function to run the model and produce a list of outputs.}

\item{setup}{A data.frame with the information about the calibration, 
normally created with the \code{\link{calibration_setup}} function. 
See details.}

\item{observed}{A list of the observed variables created with the 
function \code{\link{calibration_data}}}

\item{aggFn}{A function to aggregate \code{fn} to a scalar value if the
returned value is a vector. Some optimization algorithm can explote the
additional information provided by a vectorial output from \code{fn}}

\item{aggregate}{boolean, if TRUE, a scalar value is returned using the 
\code{aggFn}.}

\item{\dots}{More arguments passed to the \code{model} function.}
}
\value{
A function, integrating the simulation of the model and the 
comparison with observed data.
}
\description{
Create a new function, to be used as the objective function in the 
calibration, given a function to run the model within R, observed data 
and information about the comparison with data.
}
\seealso{
\code{\link{calibration_data}}, \code{\link{calibration_setup}}.
}
\author{
Ricardo Oliveros-Ramos
}
