% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{get_capl_bar_plot}
\alias{get_capl_bar_plot}
\title{Render a bar plot for a given CAPL-2 domain score, grouped by CAPL-2 interpretative categories.}
\usage{
get_capl_bar_plot(
  score = NA,
  interpretation = NA,
  x_label = "Interpretation",
  y_label = "Score",
  colors = c("#333376", "#00a79d", "#f26522", "#a6ce39")
)
}
\arguments{
\item{score}{A numeric vector.}

\item{interpretation}{A character vector representing CAPL-2 interpretative categories ("beginning", "progressing", "achieving", "excelling").}

\item{x_label}{An optional character vector representing the x-axis label. This argument is set to "Interpretation" by default.}

\item{y_label}{An optional character vector representing the y-axis label. This argument is set to "Score" by default.}

\item{colors}{An optional character vector representing the color palette for the bars. This argument is set to CAPL-2 branding colors by default
(c("#333376", "#00a79d", "#f26522", "#a6ce39", "#747474")).}
}
\value{
Renders a ggplot2 bar plot (if valid).
}
\description{
This function renders a bar plot for a given CAPL-2 domain score, grouped by CAPL-2 interpretative categories.
}
\details{
Other \code{capl} functions called by this function include: \code{\link[=validate_character]{validate_character()}}, \code{\link[=validate_number]{validate_number()}} and \code{\link[=capitalize_character]{capitalize_character()}}.
}
\examples{
capl_results <- get_capl_demo_data(n = 25)

get_capl_bar_plot(
  score = capl_results$capl_score, 
  interpretation = capl_results$capl_interpretation,
  x_label = "Overall physical literacy interpretation",
  y_label = "Overall physical literacy score",
)

}
