% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motivation_and_confidence.R
\name{get_mc_score}
\alias{get_mc_score}
\title{Compute a motivation and confidence domain score.}
\usage{
get_mc_score(
  predilection_score = NA,
  adequacy_score = NA,
  intrinsic_motivation_score = NA,
  pa_competence_score = NA
)
}
\arguments{
\item{predilection_score}{A numeric vector (valid values are between 1.8 and 7.5).}

\item{adequacy_score}{A numeric vector (valid values are between 1.8 and 7.5).}

\item{intrinsic_motivation_score}{A numericvector (valid values are between 1.5 and 7.5).}

\item{pa_competence_score}{A numeric vector (valid values are between 1.5 and 7.5).}
}
\value{
Returns a numeric vector with values between 0 and 30 (if valid) or NA (if not valid).
}
\description{
This function computes a motivation and confidence domain score (\code{mc_score}) based on the predilection (\code{predilection_score}), adequacy
(\code{adequacy_score}), intrinsic motivation (\code{intrinsic_motivation_score}) and physical activity competence (\code{pa_competence_score}) scores. If one of the
scores is missing or invalid, a weighted domain score will be computed from the other three scores. This score is used to compute the overall physical
literacy score (\code{capl_score}).
}
\details{
Other \code{capl} functions called by this function include: \code{\link[=validate_number]{validate_number()}}.
}
\examples{
get_mc_score(
  predilection_score = c(7, 7.5, 5, 8, 4),
  adequacy_score = c(NA, 5, 3, 1, 4),
  intrinsic_motivation_score = c(5, 7.5, 4, 2, 3.5),
  pa_competence_score = c(6, 3, 6, 7, 2)
)

# [1] 24.0 23.0 18.0   NA 13.5

}
