# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Estimate weighted covariance
#' @description Efficient C implementation of the sample covariance estimator. 
#' The denominator is defined as the sum of all weights. 
#' @param x Covariate without weighting (numeric vector).
#' @param y Response. The mean of the response contains weights (numeric vector).
#' @param w Weights for averaging (numeric vector).
#' @return Weighted variance (numeric scalar).
#' @author Thomas Welchowski
#' @keywords survival
#' @note If all weights are set to 1, the denominator is identical to n. 
#' There are no safety checks of input arguments.
#' @examples 
#' # Simulate two random vectors
#' set.seed(3975)
#' x <- rnorm(100)
#' set.seed(-3975)
#' y <- rnorm(100)
#' # Calculate variance with standard R function
#' # Rescaling ensures that both calculations use same denominator "n"
#' covarEst <- cov(x, y) * (100-1) / 100
#' # Calculate weighted variance with equal weights
#' equalW <- rep(1, 100)
#' weightCovarEst <- weightedCovarRcpp(x=x, y=y, w=equalW)
#' # Output comparison
#' all.equal(covarEst, weightCovarEst)
#' # Runtime comparison
#' library(microbenchmark)
#' microbenchmark(Default=cov(x, y), New=weightedCovarRcpp(x=x, y=y, w=equalW), times=25)
#' # -> New method is multiple times faster
#' @export
weightedCovarRcpp <- function(x, y, w) {
    .Call(`_carSurv_weightedCovarRcpp`, x, y, w)
}

#' @title Estimate weighted covariance
#' @description Efficient C implementation of the sample covariance estimator. 
#' The denominator is defined as the sample size.
#' @param x Covariate without weighting (numeric vector).
#' @param y Response. The mean of the response contains weights (numeric vector).
#' @param w Weights for averaging (numeric vector).
#' @return Weighted variance (numeric scalar).
#' @author Thomas Welchowski
#' @keywords survival
#' @note There are no safety checks of input arguments. 
#' @examples 
#' # Simulate two random vectors
#' set.seed(3975)
#' x <- rnorm(100)
#' set.seed(-3975)
#' y <- rnorm(100)
#' # Calculate variance with standard R function
#' # Rescaling ensures that both calculations use same denominator "n"
#' covarEst <- cov(x, y) * (100-1) / 100
#' # Calculate weighted variance with equal weights
#' equalW <- rep(1, 100)
#' weightCovarEst <- weightedCovarRcppN(x=x, y=y, w=equalW)
#' # Output comparison
#' all.equal(covarEst, weightCovarEst)
#' # Runtime comparison
#' library(microbenchmark)
#' microbenchmark(Default=cov(x, y), New=weightedCovarRcpp(x=x, y=y, w=equalW), times=25)
#' # -> New method is multiple times faster
#' @export
weightedCovarRcppN <- function(x, y, w) {
    .Call(`_carSurv_weightedCovarRcppN`, x, y, w)
}

#' @title Estimate weighted variance
#' @description Efficient C implementation of the sample variance estimator. 
#' The denominator is defined as sum of all weights.
#' @param y Response. The mean of the response contains weights (numeric vector).
#' @param w Weights for averaging (numeric vector).
#' @return Weighted variance (numeric scalar).
#' @author Thomas Welchowski
#' @keywords survival
#' @note If all weights are set to 1, the denominator is identical to n.
#' There are no safety checks of input arguments.
#' @examples 
#' # Simulate a random vector
#' set.seed(3975)
#' x <- rnorm(100)
#' # Calculate variance with standard implementation
#' # Rescaling ensures that both calculations use same denominator "n"
#' varEst <- var(x) * (100-1) / 100
#' # Calculate weighted variance with equal weights
#' equalW <- rep(1/100, 100)
#' weightVarEst <- weightedVarRcpp(y=x, w=equalW)
#' # Output comparison
#' all.equal(varEst, weightVarEst)
#' # Runtime comparison
#' library(microbenchmark)
#' microbenchmark(Default=var(x), New=weightedVarRcppN(y=x, w=equalW), times=25)
#' # -> New method is multiple times faster
#' @export
weightedVarRcpp <- function(y, w) {
    .Call(`_carSurv_weightedVarRcpp`, y, w)
}

#' @title Estimate weighted variance
#' @description Efficient C implementation of the sample variance estimator. 
#' The denominator is defined as the sample size.
#' @param y Response. The mean of the response contains weights (numeric vector).
#' @param w Weights for averaging (numeric vector).
#' @return Weighted variance (numeric scalar).
#' @author Thomas Welchowski
#' @keywords survival
#' @note There are no safety checks of input arguments.
#' @examples 
#' # Simulate a random vector
#' set.seed(3975)
#' x <- rnorm(100)
#' # Calculate variance with standard implementation
#' varEst <- var(x) * (100-1) / 100
#' # Calculate weighted variance with equal weights
#' equalW <- rep(1, 100)
#' weightVarEst <- weightedVarRcppN(y=x, w=equalW)
#' # Output comparison
#' all.equal(varEst, weightVarEst)
#' # Runtime comparison
#' library(microbenchmark)
#' microbenchmark(Default=var(x), New=weightedVarRcppN(y=x, w=equalW), times=25)
#' # -> New method is multiple times faster
#' @export
weightedVarRcppN <- function(y, w) {
    .Call(`_carSurv_weightedVarRcppN`, y, w)
}

