% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coding.R
\name{procedure_codes}
\alias{procedure_codes}
\title{Center for Medicare and Medicaid Services (CMS) Procedure Codes}
\usage{
procedure_codes(format, version)
}
\arguments{
\item{format}{The format of the procedure codes, written as a \code{character}.
Currently supported formats are: \code{c("icd9", "icd10", "hcpcs", "cpt")}
(case-insensitive).}

\item{version}{The version of the procedure codes, which are generally
written as a year. Currently supported: \code{c("2014", "2023")}}
}
\value{
A \code{tbl_df} with two columns: \code{code} and \code{description}. The \code{code}
refers to the procedure code, while the \code{description} refers to the
description of the procedure.
}
\description{
This is a generative function used to call CMS procedure codes.
It is used to create a dataset that can be generally used to map procedure
codes to their descriptions, allowing for understanding of interventions
performed. The currently supported codes are explained in the details.

The following procedure codes are currently supported:
\itemize{
\item ICD9 procedure codes, most recently updated on \code{2014-10-01}
\item ICD10 procedure codes, most recently updated on \code{2023-01-11}
\item HCPCS prcoedure codes, most recently updated on \code{2023-11-29}
\item CPT procedure codes, most recently updated on \code{2023-11-29}
}
}
\details{
CMS will usually release updated version of these codes on an annual
basis. Each dataset that is supported below can be identified by the year
it was published (not the \emph{go-live} date, but the \emph{publically-available}
date). The previous versions that are included in the package are as below.
\itemize{
\item ICD9: 2014
\item ICD10: 2023
\item HCPCS: 2023
\item CPT: 2023
}
}
\examples{
# Procedure codes from the 2014 version of ICD-9
icd9 <- procedure_codes(format = "icd9", version = 2014)

}
