% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caretList.R
\name{defaultControl}
\alias{defaultControl}
\title{Construct a default train control for use with caretList}
\usage{
defaultControl(
  target,
  method = "cv",
  number = 5L,
  savePredictions = "final",
  index = caret::createFolds(target, k = number, list = TRUE, returnTrain = TRUE),
  is_class = is.factor(target) || is.character(target),
  is_binary = length(unique(target)) == 2L,
  ...
)
}
\arguments{
\item{target}{the target variable.}

\item{method}{the method to use for trainControl.}

\item{number}{the number of folds to use.}

\item{savePredictions}{the type of predictions to save.}

\item{index}{the fold indexes to use.}

\item{is_class}{logical, is this a classification or regression problem.}

\item{is_binary}{logical, is this binary classification.}

\item{...}{other arguments to pass to \code{\link[caret]{trainControl}}}
}
\description{
Unlike caret::trainControl, this function defaults to 5 fold CV.
CV is good for stacking, as every observation is in the test set exactly once.
We use 5 instead of 10 to save compute time, as caretList is for fitting many
models. We also construct explicit fold indexes and return the stacked predictions,
which are needed for stacking. For classification models we return class probabilities.
}
