% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcms_ensembles.R
\name{gcms_ensembles}
\alias{gcms_ensembles}
\title{Ensemble GCMs into one scenario}
\usage{
gcms_ensembles(i, gcms = NULL)
}
\arguments{
\item{i}{A \code{input_sdm} object.}

\item{gcms}{GCM codes in \code{scenarios_names(i)} to group scenarios.}
}
\value{
A \code{input_sdm} object with grouped GCMs.
}
\description{
An ensembling method to group different GCMs into one SSP scenario
}
\examples{
# Create sdm_area object:
set.seed(1)
sa <- sdm_area(parana, cell_size = 100000, crs = 6933)

# Include predictors:
sa <- add_predictors(sa, bioc)

# Include scenarios:
sa <- add_scenarios(sa, scen) |> select_predictors(c("bio1", "bio12"))

# Create occurrences:
oc <- occurrences_sdm(occ, crs = 6933) |> join_area(sa)

# Create input_sdm:
i <- input_sdm(oc, sa)

# Pseudoabsence generation:
i <- pseudoabsences(i, method="random", n_set = 2)

# Custom trainControl:
ctrl_sdm <- caret::trainControl(method = "boot",
                                number = 1,
                                classProbs = TRUE,
                                returnResamp = "all",
                                summaryFunction = summary_sdm,
                                savePredictions = "all")

# Train models:
i <- train_sdm(i,
               algo = c("naive_bayes"),
               ctrl=ctrl_sdm,
               variables_selected = c("bio1", "bio12")) |>
  suppressWarnings()

# Predict models:
i  <- predict_sdm(i, th=0.8)

# Ensemble GCMs:
i <- gcms_ensembles(i, gcms = c("ca", "mi"))
i

}
\seealso{
\code{\link{GBIF_data} \link{occurrences_sdm} \link{sdm_area} \link{input_sdm}
\link{predictors}}
}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
