test_that("input_sdm", {
  sa <- sdm_area(parana, cell_size = 0.25)
  sa <- add_predictors(sa, bioc)
  sa <- select_predictors(sa, c("bio1", "bio12"))
  sa <- add_scenarios(sa, scen[,,,c("bio1", "bio12")])
  oc <- occurrences_sdm(occ, crs = 6933)
  expect_warning(i <- input_sdm(oc, sa))
  expect_equal(colnames(oc$occurrences), c("species", "geometry"))
  expect_equal(colnames(i$occurrences$occurrences), c("cell_id", "species", "geometry"))
  expect_true(all(sa$scenarios$data$ssp585_2090 == i$scenarios$data$ssp585_2090))
  expect_true(all(sa$grid == i$predictors$grid))
  expect_warning( oc <- occurrences_sdm(occ, crs = 6933) |> join_area(sa) )
  i <- input_sdm(oc, sa)
  expect_true(all(oc$occurrences == i$occurrences$occurrences))
  expect_true(all(sa$scenarios$data$ssp585_2090 == i$scenarios$data$ssp585_2090))
  expect_true(all(sa$grid == i$predictors$grid))
  expect_error(input_sdm(sa,sa))
  skip_on_cran()
  expect_snapshot(i)
})
