% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex-align.R
\name{flex_align}
\alias{flex_align}
\title{Flex cross axis alignment}
\usage{
flex_align(x, ...)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{...}{A character string specifying the cross axis alignment. One of,
\itemize{
\item \code{"start"}
\item \code{"end"}
\item \code{"center"}
\item \code{"baseline"}
\item \code{"stretch"}

Use name-value pairs to specify \link{breakpoints}.
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{flex_align()} function adjusts a tag element's cross axis alignment. By
default, the cross axis is the y-axis. When using \code{flex_direction("column")}
the cross axis becomes the x-axis.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    flex_display() \%>\%
    flex_align("center"),
  div("Flex item"),
  div("Flex item"),
  div("Flex item")
)

}
\seealso{
Other flex utilities: 
\code{\link{flex_content}()},
\code{\link{flex_direction}()},
\code{\link{flex_display}()},
\code{\link{flex_justify}()},
\code{\link{flex_wrap}()},
\code{\link{item_align}()},
\code{\link{item_fill}()},
\code{\link{item_grow}()},
\code{\link{item_order}()}
}
\concept{flex utilities}
