% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item-order.R
\name{item_order}
\alias{item_order}
\title{Flex reordering}
\usage{
item_order(x, ...)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{...}{A number or character string specifying a position. One of,
\itemize{
\item \code{0}
\item \code{1}
\item \code{2}
\item \code{3}
\item \code{4}
\item \code{5}
\item \code{"first"}
\item \code{"last"}

Use name-value pairs to specify \link{breakpoints}.
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{item_order()} function adjusts the visual order of a tag element.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    flex_display(),
  div(
    .style \%>\%
      item_order(3),
    "Third flex item"
  ),
  div(
    .style \%>\%
      item_order(2),
    "Second flex item"
  ),
  div(
    "First flex item"
  )
)

}
\seealso{
Other flex utilities: 
\code{\link{flex_align}()},
\code{\link{flex_content}()},
\code{\link{flex_direction}()},
\code{\link{flex_display}()},
\code{\link{flex_justify}()},
\code{\link{flex_wrap}()},
\code{\link{item_align}()},
\code{\link{item_fill}()},
\code{\link{item_grow}()}
}
\concept{flex utilities}
