% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position.R
\name{position}
\alias{position}
\title{Positioning elements}
\usage{
position(x, method)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{method}{A character string specifying the positioning method. One of,
\itemize{
\item \code{"static"}
\item \code{"relative"}
\item \code{"absolute"}
\item \code{"fixed"}
\item \code{"sticky"}
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \verb{position_*()} functions adjust set the position of an element.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    position("absolute") \%>\%
    position_top(50)
)

}
\seealso{
Other position utilities: 
\code{\link{position_centered}()},
\code{\link{position_sticky}()}
}
\concept{position utilities}
