% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sim.R
\docType{class}
\name{Simulation-class}
\alias{Simulation-class}
\title{An S4 class to represent a simulation task.}
\description{
An S4 class to represent a simulation task.
}
\section{Slots}{

\describe{
\item{\code{startNo}}{The starting simulation index.}

\item{\code{simNo}}{Number of simulation.}

\item{\code{lines}}{A string vector to identify the business line(s) to be simulated.}

\item{\code{types}}{A string vector to identify the claim types to be simulated.}

\item{\code{iRBNER}}{A Boolean indicating whether IBNER claims need to be simulated.}

\item{\code{iROPEN}}{A Boolean indicating whether claim reopening needs to be simulated.}

\item{\code{iIBNR}}{A Boolean indicating whether IBNR claims need to be simulated.}

\item{\code{iUPR}}{A Boolean indicating whether future claims need to be simulated.}

\item{\code{claimobjs}}{A list of claim objects.}

\item{\code{workingFolder}}{A string to specify the working folder where the simulation results will be saved.}

\item{\code{iCopula}}{A Boolean indicating whether to use copula for frequency simulation.}

\item{\code{freqCopula}}{Frequency copula.}

\item{\code{iSummary}}{A Boolean indicating whether to summarzie the simulation results.}

\item{\code{iReport}}{A Boolean indicating whether to generate an HTML report.}

\item{\code{iFit}}{A Boolean indicating whether to fit some simulation parameters based on claim data.}

\item{\code{ncores}}{Number of cores used for simulation.}

\item{\code{tag}}{A unique tag for the simulation object including date and a random ID.}

\item{\code{fitfile}}{A string to set the distribution fitting file name. If omitted, a name based on tag will be used.}

\item{\code{copfile}}{A string to set the copula fitting file name. If omitted, a name based on tag will be used.}

\item{\code{facfile}}{A string to set the factor fitting file name. Factor table is development year dependant. It could be the probability of zero payment, reopen probability, or loss development factors. If omitted, a name based on tag will be used.}

\item{\code{fitRpt}}{A string to set the distribution fitting html report file name. If omitted, a name based on tag will be used.}

\item{\code{simfile}}{A string to set the simulation result file name. If omitted, a name based on tag will be used.}

\item{\code{sumfile}}{A string to set the summary file name. If omitted, a name based on tag will be used.}

\item{\code{plog}}{A string to set the parallel run log file name. If omitted, a name based on tag will be used.}

\item{\code{htmlRpt}}{A string to set the html report name. If omitted, a name based on tag will be used.}

\item{\code{libpath}}{A string to the R liabrary folder where required packages are installed.}
}}

