% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nte_cat}
\alias{nte_cat}
\title{Need to Evaluate Cat Object}
\format{
An object of class \code{Cat} of length 1.
}
\source{
See \code{https://dataverse.harvard.edu/dataverse/pdsl} for the raw YouGov and/or Qualtrics data.

See \url{https://wc.wustl.edu} for raw TAPS data.
}
\usage{
data(nte_cat)
}
\description{
Cat object containing item parameters for graded response model fit with responses to the 16 item Need to Evaluate inventory
}
\details{
Cat object containing item parameters for graded response model fit with
  2534 response profiles from MTurk,
4993 response profiles collected by Qualtrics in June 2018,
and 1512 response profiles from The American Panel Survey (TAPS) in December 2014.
TAPS is a monthly online panel survey  of about 2,000 adults in the United States.
The panel was recruited in the fall of 2011 using an address-based sampling frame.
TAPS surveys are administered online.  Selected panelists who do not have a computer or
 online service are provided a computer and internet access by TAPS. 

See \code{\link{Cat-class}} for details regarding the Cat object structure.
See \code{\link{grmCat}} for details regarding the graded response model.

A normal prior was chosen with mean from the theta estimates from the TAPS sample (.002) and a standard deviation (1.3)
wide enough to envelope the range of estimated theta values across both samples.

Note that due to how the item parameters were estimated, large, positive values indicate "more" of the latent trait.

Response options are:

5 = Extremely characteristic of me, 4 = Somewhat characteristic of me, 3 = Uncertain, 2 = Somewhat uncharacteristic of me, 1 = Extremely uncharacteristic of me

The wording of the question items is: 

\describe{
\item{\code{q1}}{ I form opinions about everything.} 
\item{\code{q2}}{ I prefer to avoid taking extreme positions.} 
\item{\code{q3}}{ It is very important to me to hold strong opinions.} 
\item{\code{q4}}{ I want to know exactly what is good and bad about everything.} 
\item{\code{q5}}{ I often prefer to remain neutral about complex issues.} 
\item{\code{q6}}{ If something does not affect me, I do not usually determine if it is good or bad.} 
\item{\code{q7}}{ I enjoy strongly liking and disliking things.}
\item{\code{q8}}{ There are many things for which I do not have a preference.} 
\item{\code{q9}}{ It bothers me to remain neutral.} 
\item{\code{q10}}{ I like to have strong opinions even when I am not personally involved.} 
\item{\code{q11}}{ I have many more opinions than the average person.}
\item{\code{q12}}{ I would rather have a strong opinion than no opinion at all.} 
\item{\code{q13}}{ I pay a lot of attention to whether things are good or bad.} 
\item{\code{q14}}{ I only form strong opinions when I have to.} 
\item{\code{q15}}{ I like to decide that new things are really good or really bad.}
\item{\code{q16}}{ I am pretty much indifferent to many important issues.} 
}
}
\references{
Jarvis, W. Blair G., and Richard E. Petty.
"The need to evaluate." Journal of personality and social psychology 70.1 (1996): 172.
}
\seealso{
\code{\link{Cat-class}}, \code{\link{grmCat}}
}
\keyword{datasets}
