% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{get_cox_risk_and_failure_sets}
\alias{get_cox_risk_and_failure_sets}
\title{Calculate Risk and Failure Sets for Cox Proportional Hazards Model}
\usage{
get_cox_risk_and_failure_sets(time_vector, status_vector, indicator_vector)
}
\arguments{
\item{time_vector}{A numeric vector of time-to-event data for each subject.}

\item{status_vector}{A numeric vector indicating event occurrence (1 = event, 0 = censored).}

\item{indicator_vector}{A numeric vector representing the indicator times used to define risk and failure sets.}
}
\value{
A list containing two elements:
\itemize{
\item \code{risk_set}: A matrix indicating which subjects are at risk at each time point.
\item \code{failure_set}: A matrix indicating which subjects experienced an event at each time point.
}
}
\description{
This function calculates the risk and failure sets for subjects in a Cox proportional hazards model based on their time-to-event data, status, and an indicator vector.
}
