% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{get_discrepancy}
\alias{get_discrepancy}
\title{Compute Discrepancy Measures}
\usage{
get_discrepancy(
  discrepancy_method = c("mean_logarithmic_error", "mean_square_error",
    "mean_classification_error", "logistic_deviance"),
  family_string = NULL,
  X = NULL,
  Y = NULL,
  coefs = NULL,
  est_Y = NULL
)
}
\arguments{
\item{discrepancy_method}{A character string specifying the discrepancy method to use. Options are:
\describe{
\item{"logarithmic_error"}{Logarithmic error, suitable for probabilities.}
\item{"mean_square_error"}{Mean squared error.}
\item{"mean_classification_error"}{Mean of classification error, suitable for binary outcomes.}
\item{"logistic_deviance"}{Logistic deviance, computed using a GLM model.}
}}

\item{family_string}{A GLM family in string (e.g., "binomial") used to compute logistic deviance.}

\item{X}{A matrix of predictor variables.}

\item{Y}{A vector or data frame of observed values.}

\item{coefs}{A vector of coefficients for the GLM model.}

\item{est_Y}{A vector of estimated values. If not provided, it will be computed using \code{get_glm_mean} with the specified \code{family}.}
}
\value{
A numeric value representing the discrepancy between observed and estimated values.
}
\description{
This function computes various discrepancy measures between observed and estimated values.
It supports different methods including logarithmic error, square error, classification error, and logistic deviance.
}
