% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{get_glm_log_density}
\alias{get_glm_log_density}
\title{Compute Log Density Based on GLM Family}
\usage{
get_glm_log_density(family_string, X, Y, coefs, weights = 1)
}
\arguments{
\item{family_string}{Character. The GLM family to use. Options are \code{"binomial"} or \code{"gaussian"}.}

\item{X}{Matrix. The design matrix (predictors) for the GLM.}

\item{Y}{Vector or data frame. The response variable for the GLM. If a data frame, it is converted to a numeric vector.}

\item{coefs}{Numeric vector. The coefficients for the GLM.}

\item{weights}{Numeric vector. Weights for the observations. Default is \code{1} (no weighting).}
}
\value{
Numeric. The computed log density of the response variable based on the specified family.
}
\description{
This function calculates the log density of the response variable given a generalized linear model (GLM)
based on the specified family. The log density is computed differently for binomial and gaussian families.
}
