% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prints.R
\name{print.cat}
\alias{print.cat}
\title{Print Method for \code{cat} Object}
\usage{
\method{print}{cat}(x, digit = 3, detail = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{cat}, representing a fitted model.}

\item{digit}{An integer indicating the number of decimal places for printing
coefficient estimates. Default is 3.}

\item{detail}{A logical indicating whether to print additional details for interpreting the output. Default is TRUE.}

\item{...}{Additional parameters to pass to other functions.}
}
\value{
The \code{x} object is returned invisibly.
}
\description{
The \code{print.cat} function provides a detailed summary of the \code{cat} object, displaying key information about the model and its settings,
including model type, covariates, formula, tau values, and relevant coefficients.
}
\details{
This function customizes the output based on the model type stored within the \code{x} object, such as GLM, Cox, or other types of models.

The \code{print.cat} function prints a summary of the model stored in the \code{x} object. It will display different information
depending on the model's type (GLM, Cox, etc.). It will show:
\itemize{
\item The model's function name.
\item The dimensions of the covariates used in the model.
\item The tau values.
\item Model-specific details such as family for GLMs or method and iteration info for Cox models.
\item Coefficients related to the model.
}
}
