% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{traceplot.cat_bayes}
\alias{traceplot.cat_bayes}
\title{Traceplot for Bayesian Sampling Model}
\usage{
\method{traceplot}{cat_bayes}(object, ...)
}
\arguments{
\item{object}{A fitted model object of class \code{cat_bayes} that contains
the Stan sampling model. The object should include the \code{stan_sample_model},
which is the result of fitting the model using the \code{rstan} package.}

\item{...}{Additional arguments passed to the \code{rstan::traceplot} function.
These can include customization options for the traceplot, such as \code{pars}
for selecting specific parameters or \code{inc_warmup} for including or excluding warmup iterations.}
}
\value{
A traceplot displaying the MCMC chains' trace for each parameter,
helping to assess convergence.
}
\description{
This function generates a traceplot for the Bayesian sampling model fitted
using \code{rstan}. It utilizes the \code{traceplot} function from the \code{rstan} package
to visualize the sampling progress and convergence of the Markov Chain Monte Carlo (MCMC) chains
for the given model.
}
\details{
The function calls \code{rstan::traceplot} on the \code{stan_sample_model} contained
within the \code{x} object. The resulting plot displays the trace of each parameter
across MCMC iterations, helping to assess the convergence and mixing of the chains.
}
