% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_cont.R, R/is.R, R/which.R
\name{cat_cont}
\alias{cat_cont}
\alias{is_cat}
\alias{is_cont}
\alias{is_cat.default}
\alias{is_cat.ordered}
\alias{is_cat.factor}
\alias{is_cat.logical}
\alias{is_cont.default}
\alias{is_cont.logical}
\alias{is_cont.factor}
\alias{is_cont.ordered}
\alias{which_cat}
\alias{which_cont}
\title{categorical or continuous variables}
\usage{
cat_cont(x)

is_cat(x)

\method{is_cat}{default}(x)

\method{is_cat}{ordered}(x)

\method{is_cat}{factor}(x)

\method{is_cat}{logical}(x)

is_cont(x)

\method{is_cont}{default}(x)

\method{is_cont}{logical}(x)

\method{is_cont}{factor}(x)

\method{is_cont}{ordered}(x)

which_cat(x, ..., names = FALSE)

which_cont(x, ..., names = FALSE)
}
\arguments{
\item{x}{object}

\item{...}{arguments passed to other functions.}

\item{names}{logical; whether to return the names of the variables instead of
their index?}
}
\value{
\code{cat_cont} returns a named character with values either "\code{cat}" or "\code{cont}".
If \code{x} is a atomic vector, a single string is given. If \code{x} is recursive,
a "\code{cat}"/"\code{cont}" value is given for each element. Names correspond to the
names of the element.

\code{is_cat} and \code{is_cont} return \code{logical}.

\code{which_cat} and \code{which.cont} report which variables in an object
are categorical and continuous.  By default, interger indices are
return.  If \code{names=TRUE}, the names of the variables are returned
instead.
}
\description{
These functions facilitate working with variables as categorical or continous
rather than logical, integer, numeric, factor, character, ..
}
\details{
These functions are used to test and identify which/if a variable or
variables are categorical or continuos.  \code{is_cat} and \code{is_cont}
take single variable arguments.

Mostly, the categorical and continuos assessment is straight-
forward. Continuous variables are respresented by \code{integer}, \code{double}
or \code{complex} types. All other types are categorical. There are a few
opinionated exceptions:
\itemize{
\item \strong{factors} are categorical (though typed 'integer')
\item \strong{ordered} factors are (though typed 'integer')
\item \strong{logical} are categorical
}

For simplicity, it is assumed that a vector cannot be simultaneous
categorical and continous, though in some cases (e.g. ordered factors) this
may be the case.
}
\examples{

  data(iris)
  cat_cont(iris)


  is_cat(letters)          # TRUE
  is_cat(factor(letters))  # TRUE
  is_cat(TRUE)             # TRUE
  is_cat(FALSE)            # TRUE
  is_cat(1:10)             # FALSE
  is_cat(rnorm(10))        # FALSE
  is_cat( Sys.Date() )     # FALSE
  is_cat( complex(1,2) )   # FALSE

  is_cont(letters)         # FALSE
  is_cont(factor(letters)) # FALSE
  is_cont(TRUE)            # FALSE
  is_cont(FALSE)           # FALSE
  is_cont(1:10)            # TRUE
  is_cont(rnorm(10))       # TRUE
  is_cont( Sys.Date() )    # TRUE
  is_cont( complex(1,2) )  # TRUE

  which_cat(iris)
  which_cat( iris, names=TRUE )

  which_cont(iris)
  which_cont( iris, names=TRUE )

}
\seealso{
\itemize{
\item \code{\link[base:typeof]{base::typeof()}}
\item \code{\link[base:is.numeric]{base::is.numeric()}} \code{\link[methods:is]{methods::is()}}
\item \code{\link[base:which]{base::which()}}
}
}
