% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matched_or.R
\name{matched_or.data.frame}
\alias{matched_or.data.frame}
\title{Matched pairs odds ratio from a data frame}
\usage{
\method{matched_or}{data.frame}(df, x, y, weight = NULL, alpha = 0.05,
  rev = c("neither", "rows", "columns", "both"), ...)
}
\arguments{
\item{df}{a dataframe with binary variables x and y.}

\item{x}{binary vector, used as rows for frequency table and calculations.}

\item{y}{binary vector, used as columns for frequency table and calculations.}

\item{weight}{an optional vector of count weights.}

\item{alpha}{level of significance for confidence interval.}

\item{rev}{reverse order of cells. Options are "row", "columns", "both", and "neither" (default).}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a list with class "matched_or" with the following components:

\item{tab}{2x2 table using for calculating risk difference}
\item{or}{dataframe with columns corresponding to matched-pairs OR, lower bound, and upper bound of CI}
\item{conf.level}{specified confidence level}
}
\description{
Create odds ratio and confidence interval from matched pairs data.
}
\examples{

gene <- data.frame(pair = seq(1:35),
                   ulcer = rbinom(35, 1, .7),
                   healthy = rbinom(35, 1, .4))

matched_or(gene, ulcer, healthy)
}
