% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riskdiff.R
\name{riskdiff.data.frame}
\alias{riskdiff.data.frame}
\title{Risk difference}
\usage{
\method{riskdiff}{data.frame}(df, x = NULL, y = NULL, weight = NULL,
  conf.level = 0.95, rev = c("neither", "rows", "columns", "both"),
  ...)
}
\arguments{
\item{df}{a dataframe with binary variables x and y.}

\item{x}{binary predictor/exposure, vector.}

\item{y}{binary outcome, vector.}

\item{weight}{an optional vector of count weights.}

\item{conf.level}{confidence level for confidence interval, default is 0.95.}

\item{rev}{reverse order of cells. Options are "row", "columns", "both", and "neither" (default).}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a list with class "rdiff" containing the following components:

\item{rd}{risk difference}
\item{conf.level}{specified confidence level}
\item{ci}{calculated confidence interval}
\item{p1}{proportion one}
\item{p2}{proportion two}
\item{tab}{2x2 table using for calculating risk difference}
}
\description{
Calculate risk difference and 95 percent confidence interval using Wald method.
}
\examples{
trial <- data.frame(
  disease = c(rep("yes", 2), rep("no", 2)),
  treatment = c(rep(c("estrogen", "placebo"), 2)),
  count = c(751, 623, 7755, 7479))

riskdiff(trial, treatment, disease, count, rev = "columns")
}
