% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.R
\name{catmap.forest}
\alias{catmap.forest}
\title{catmap: Forest Plot}
\usage{
catmap.forest(catmapobject, fe.forest = FALSE, re.forest = FALSE)
}
\arguments{
\item{catmapobject}{A catmap object created by \code{\link{catmap}}.}

\item{fe.forest}{A boolean. Toggles whether the forest plot should get saved
to the current working directory.}

\item{re.forest}{A boolean. Toggles whether the forest plot should get saved
to the current working directory.}
}
\description{
The \code{catmap.forest} creates forest plots of the individual study
 Odds Ratios (OR) and Confidence Intervals (CI). It then summarizes the
 data using a fixed-effects or random-effects pooled OR and CI.
}
\examples{
data(catmapdata)
catmapobject <- catmap(catmapdata, 0.95, TRUE)
catmap.forest(catmapobject, TRUE, TRUE)
}
\seealso{
\code{\link{catmap}}, \code{\link{catmap.forest}},
 \code{\link{catmap.sense}}, \code{\link{catmap.cumulative}},
 \code{\link{catmap.funnel}}
}
\author{
Algorithm designed and implemented by Kristin K. Nicodemus.
 Code modified and updated by Thom Quinn.
}
