% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{caugi_layout_sugiyama}
\alias{caugi_layout_sugiyama}
\title{Sugiyama Hierarchical Layout}
\source{
Sugiyama, K., Tagawa, S., & Toda, M. (1981). Methods for visual
understanding of hierarchical system structures. IEEE Transactions on
Systems, Man, and Cybernetics, 11(2), 109-125.
\doi{10.1109/TSMC.1981.4308636}
}
\usage{
caugi_layout_sugiyama(x, packing_ratio = 1.618034, ...)
}
\arguments{
\item{x}{A \code{caugi} object. Must contain only directed edges.}

\item{packing_ratio}{Aspect ratio for packing disconnected components
(width/height). Default is the golden ratio (1.618) which works well with
widescreen displays. Use \code{1.0} for square grid, \code{2.0} for wider layouts,
\code{0.5} for taller layouts, \code{Inf} for single row, or \code{0.0} for single column.}

\item{...}{Ignored. For future extensibility.}
}
\value{
A \code{data.frame} with columns \code{name}, \code{x}, and \code{y} containing node
names and their coordinates.
}
\description{
Computes node coordinates using the Sugiyama hierarchical layout algorithm.
Optimized for directed acyclic graphs (DAGs), placing nodes in layers to
emphasize hierarchical structure and causal flow from top to bottom.
}
\examples{
cg <- caugi(A \%-->\% B + C, B \%-->\% D, C \%-->\% D, class = "DAG")
layout <- caugi_layout_sugiyama(cg)

}
\seealso{
Other plotting: 
\code{\link{add-caugi_plot-caugi_plot}},
\code{\link{caugi_layout}()},
\code{\link{caugi_layout_bipartite}()},
\code{\link{caugi_layout_fruchterman_reingold}()},
\code{\link{caugi_layout_kamada_kawai}()},
\code{\link{caugi_layout_tiered}()},
\code{\link{caugi_plot}()},
\code{\link{divide-caugi_plot-caugi_plot}},
\code{\link{plot}()}
}
\concept{plotting}
