% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{divide-caugi_plot-caugi_plot}
\alias{divide-caugi_plot-caugi_plot}
\title{Compose Plots Vertically}
\arguments{
\item{e1}{A \code{caugi_plot} object (top plot)}

\item{e2}{A \code{caugi_plot} object (bottom plot)}
}
\value{
A \code{caugi_plot} object containing the composed layout
}
\description{
Stack two plots vertically with configurable spacing. Compositions can
be nested to create complex multi-plot layouts.
}
\details{
The spacing between plots is controlled by the global option
\code{caugi_options()$plot$spacing}, which defaults to \code{grid::unit(1, "lines")}.
Compositions can be nested arbitrarily:
\itemize{
\item \code{p1 / p2} - two plots stacked vertically
\item \code{p1 / p2 / p3} - three plots in a column
\item \code{(p1 + p2) / p3} - two plots on top, one below
}
}
\examples{
cg1 <- caugi(A \%-->\% B, B \%-->\% C)
cg2 <- caugi(X \%-->\% Y, Y \%-->\% Z)

p1 <- plot(cg1, main = "Graph 1")
p2 <- plot(cg2, main = "Graph 2")

# Vertical composition
p1 / p2

# Mixed composition
(p1 + p2) / p1

}
\seealso{
\code{\link[=caugi_options]{caugi_options()}} for configuring spacing and default styles

Other plotting: 
\code{\link{add-caugi_plot-caugi_plot}},
\code{\link{caugi_layout}()},
\code{\link{caugi_layout_bipartite}()},
\code{\link{caugi_layout_fruchterman_reingold}()},
\code{\link{caugi_layout_kamada_kawai}()},
\code{\link{caugi_layout_sugiyama}()},
\code{\link{caugi_layout_tiered}()},
\code{\link{caugi_plot}()},
\code{\link{plot}()}
}
\concept{plotting}
