% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densities.R
\name{hdi.ancestralCauchy}
\alias{hdi.ancestralCauchy}
\title{Highest (Posterior) Density Interval}
\usage{
\method{hdi}{ancestralCauchy}(object, credMass = 0.95, allowSplit = TRUE, node, ...)
}
\arguments{
\item{object}{an object of class \code{ancestralCauchy}, result of function
\code{\link{ancestral}} or \code{\link{increment}}.}

\item{credMass}{a scalar between 0 and 1 specifying the mass within the credible interval.}

\item{allowSplit}{if FALSE and the proper HDI is discontinuous,
a single credible interval is returned, but this is not HDI.
See \code{\link[HDInterval]{hdi}} for details. Default to \code{TRUE}.}

\item{node}{the vector of nodes where to plot the ancestral reconstruction.
Can be missing, in which case all the nodes reconstructed in the \code{ancestralCauchy}}

\item{...}{further arguments to be passed to \code{\link{plot}}.}
}
\value{
A named list. Each item of the list is named after a node,
and contains the HDI interval of the node, in the same format
as in \code{\link[HDInterval]{hdi}}: 
a vector of length 2 or a 2-row matrix with the lower and upper limits of the HDI, 
with an attribute \code{credMass}.
If \code{allowSplit=TRUE}, the matrix has a row for each component of a discontinuous HDI 
and columns for begin and end.
It has an additional attribute "height" giving the probability density at the limits of the HDI.
}
\description{
This function takes an object of class \code{ancestralCauchy}, result of function
\code{\link{ancestral}} or \code{\link{increment}}, and find the Highest (Posterior) Density Interval 
of reconstructed states for given nodes.
It relies on function \code{\link[HDInterval]{hdi}} from package \code{\link[HDInterval]{HDInterval}}.
}
\details{
The function relies on the \code{density} method of the \code{\link[HDInterval]{hdi}} function.
Package \code{\link[HDInterval]{HDInterval}} must be loaded in the workspace for this
function to work.
See documentation of this functions for more details on the definition and
computation of the HDI.

The density is obtained on the grid of values defined by the 
\code{ancestralCauchy} object, which defaults to 100 values.
See details in the documentation of the 
\code{\link{ancestral}} and \code{\link{increment}} functions.

NOTE: if the grid of values is too coarse (if it has too few values),
then the result can be a poor approximation.
Please make sure to use an appropriate grid in the reconstruction to 
get meaningful results (see example).
}
\examples{
# Lizard dataset
data(lizards)
attach(lizards)
# Fit CP
fit_CP <- fitCauchy(phy, svl, model = "cauchy", method = "reml")
# Reconstruct increments for some branches
inc <- increment(fit_CP, node = c(142, 151), n_cores = 1)
# HDI
library(HDInterval)
inc_int <- hdi(inc)
plot(inc, intervals = inc_int, type = "l")
# HDI of edge ending at node 142 is unimodal
inc_int[["142"]]
# HDI of edge ending at node 151 is bimodal
inc_int[["151"]]
# If the grid is coarse, the result is meaningless
inc <- increment(fit_CP, node = c(151), n_cores = 1, n_values = 10)
inc_int <- hdi(inc)
plot(inc, intervals = inc_int, type = "l")

}
\seealso{
\code{\link{plot.ancestralCauchy}}, \code{\link{ancestral}}, \code{\link{increment}}, \code{\link{fitCauchy}}
}
