% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction_functions_v2.R
\name{p.mu}
\alias{p.mu}
\title{Predict vector of probabilities from vector of latent means}
\usage{
p.mu(mu, d = NULL, bound = NULL, npts = 100, rel.tol = 1e-04)
}
\arguments{
\item{mu}{d-length vector of latent means}

\item{d}{input to avoid computing length of mu}

\item{bound}{input of mu[1] to avoid computation}

\item{npts}{number of integration points, default 100}

\item{rel.tol}{number of integration points, default 1e-4}
}
\value{
A d-length numeric vector of probabilities given input latent means
}
\description{
Predict vector of probabilities from vector of latent means
}
\examples{
set.seed(1)
mu <- rnorm(5)
p.mu(mu)
}
