% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_price_index.R
\name{calculate_price_index}
\alias{calculate_price_index}
\title{Calculate index based on specified method (Fisher, Laspeyres, Paasche, HMTS)}
\usage{
calculate_price_index(
  method,
  dataset,
  period_variable,
  dependent_variable,
  continuous_variables,
  categorical_variables,
  reference_period = NULL,
  number_of_observations = TRUE,
  periods_in_year = 4,
  production_since = NULL,
  number_preliminary_periods = 3,
  resting_points = FALSE,
  index = TRUE,
  imputation = FALSE
)
}
\arguments{
\item{method}{one of: "fisher", "laspeyres", "paasche", "hmts"}

\item{dataset}{data frame with input data}

\item{period_variable}{name of the variable indicating time periods}

\item{dependent_variable}{usually the price}

\item{continuous_variables}{vector with numeric quality-determining variables}

\item{categorical_variables}{vector with categorical variables (also dummies)}

\item{reference_period}{period or group of periods that will be set to 100}

\item{number_of_observations}{show number of observations? Default = TRUE}

\item{periods_in_year}{(HMTS only) number of periods per year (e.g. 12 for months)}

\item{production_since}{(HMTS only) start period for production simulation}

\item{number_preliminary_periods}{(HMTS only) number of preliminary periods}

\item{resting_points}{(HMTS only) return detailed outputs? Default = FALSE}

\item{index}{(Laspeyres/Paasche only) include index column? Default = TRUE}

\item{imputation}{(Laspeyres/Paasche only) include imputation values? Default = FALSE}
}
\value{
A data.frame (or list for when method is HMTS with resting_points = TRUE)
}
\description{
Central hub function to calculate index figures using different methods.
}
\examples{
# Laspeyres index
Tbl_Laspeyres <- calculate_price_index(
  method = "laspeyres",
  dataset = data_constraxion,
  period_variable = "period",
  dependent_variable = "price",
  continuous_variables = "floor_area",
  categorical_variables = "neighbourhood_code",
  reference_period = 2015,
  number_of_observations = TRUE,
  imputation = FALSE
)
head(Tbl_Laspeyres)

# Paasche index
Tbl_Paasche <- calculate_price_index(
  method = "paasche",
  dataset = data_constraxion,
  period_variable = "period",
  dependent_variable = "price",
  continuous_variables = "floor_area",
  categorical_variables = "neighbourhood_code",
  reference_period = 2015,
  number_of_observations = TRUE,
  imputation = FALSE
)
head(Tbl_Paasche)

# Fisher index (geometric mean of Laspeyres and Paasche)
Tbl_Fisher <- calculate_price_index(
  method = "fisher",
  dataset = data_constraxion,
  period_variable = "period",
  dependent_variable = "price",
  continuous_variables = "floor_area",
  categorical_variables = "neighbourhood_code",
  reference_period = 2015,
  number_of_observations = TRUE
)
head(Tbl_Fisher)
}
\author{
Vivek Gajadhar
}
