% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_reduced_rank_regression.R
\name{cca_group_rrr}
\alias{cca_group_rrr}
\title{Group-Sparse Canonical Correlation via Reduced-Rank Regression}
\usage{
cca_group_rrr(
  X,
  Y,
  groups,
  Sx = NULL,
  Sy = NULL,
  Sxy = NULL,
  lambda = 0,
  r,
  standardize = FALSE,
  LW_Sy = TRUE,
  solver = "ADMM",
  rho = 1,
  niter = 10000,
  thresh = 1e-04,
  thresh_0 = 1e-06,
  verbose = FALSE
)
}
\arguments{
\item{X}{Predictor matrix (n x p)}

\item{Y}{Response matrix (n x q)}

\item{groups}{List of index vectors defining groups of predictors}

\item{Sx}{Optional covariance matrix for X; if NULL computed internally}

\item{Sy}{Optional covariance matrix for Y; if NULL computed internally}

\item{Sxy}{Optional cross covariance matrix for X and Y; if NULL computed internally}

\item{lambda}{Regularization parameter}

\item{r}{Target rank}

\item{standardize}{Whether to scale variables}

\item{LW_Sy}{Whether to apply Ledoit-Wolf shrinkage to Sy (default TRUE)}

\item{solver}{Either "ADMM" or "CVXR"}

\item{rho}{ADMM parameter}

\item{niter}{Maximum number of ADMM iterations}

\item{thresh}{Convergence threshold for ADMM}

\item{thresh_0}{tolerance for declaring entries non-zero}

\item{verbose}{Print diagnostics}
}
\value{
A list with elements:
\describe{
\item{U}{Canonical direction matrix for X (p x r)}
\item{V}{Canonical direction matrix for Y (q x r)}
\item{cor}{Canonical covariances}
\item{loss}{The prediction error 1/n * \| XU - YV\|^2}
}
}
\description{
Performs group-sparse reduced-rank regression for CCA using either ADMM or CVXR solvers.
}
