% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical-APIs.R
\name{get_fate_by_dtxsid}
\alias{get_fate_by_dtxsid}
\title{Get fate by DTXSID}
\usage{
get_fate_by_dtxsid(
  DTXSID = NULL,
  API_key = NULL,
  Server = chemical_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSID}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some “progress report” should be given.}
}
\value{
@return A data.frame containing chemical information for the chemical with
DTXSID matching the input parameter.
}
\description{
Get fate by DTXSID
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Pull chemical fate data for BPA
bpa <- get_fate_by_dtxsid(DTXSID = 'DTXSID7020182')
\dontshow{\}) # examplesIf}
}
