# Data verification columns
pkg.globals <- new.env()
pkg.globals$columnNames.Min <- "min"
pkg.globals$columnNames.Max <- "max"
pkg.globals$columnNames.Outlier <- "outlier"
pkg.globals$columnNames.Operations <- "operations"
pkg.globals$columnNames.Variable <- "variable"

# Variable Details Sheet Column Names
pkg.globals$argument.Data <- "data"
pkg.globals$argument.Variables <- "variable"
pkg.globals$argument.VariableDetailsSheet <- "variableDetailsSheet"
pkg.globals$argument.VariableStart <- "variableStart"
pkg.globals$argument.VariableStartType <- "variableStartType"
pkg.globals$argument.DatabaseStart <- "databaseStart"
pkg.globals$argument.VariableStartHigh <- "high"
pkg.globals$argument.VariableStartLow <- "low"
pkg.globals$argument.CatStartValue <- "value"
pkg.globals$argument.CatStartLabel <- "valueLabelStart"
pkg.globals$argument.VariableStartLabel <- "label"
pkg.globals$argument.From <- "recStart"
pkg.globals$argument.Interval <- "interval"
pkg.globals$argument.CatValue <- "recEnd"
pkg.globals$argument.Notes <- "notes"
pkg.globals$argument.ToType <- "typeEnd"
pkg.globals$argument.Units <- "units"
pkg.globals$argument.VariableLabel <- "variableStartLabel"
pkg.globals$argument.VariableLabelShort <- "variableStartShortLabel"
pkg.globals$argument.CatLabelLong <- "catLabelLong"
pkg.globals$argument.CatLabel <- "catLabel"
pkg.globals$argument.CatType <- "cat"
pkg.globals$argument.VariableStartHighLow <- "from"
pkg.globals$argument.Role <- "role"

# DDI object names
pkg.globals$ddiValue.Min <- "min"
pkg.globals$ddiValue.Max <- "max"
pkg.globals$ddiValueName.Cont <- "cont"
pkg.globals$ddiValueName.Cat <- "cat"
pkg.globals$ddiValueName.Categorical <- "Categorical"

# BLLFlow object content
pkg.globals$bllFlowContent.Data <- "data"
pkg.globals$bllFlowContent.Variables <- "variables"
pkg.globals$bllFlowContent.VariableDetails <- "variableDetails"
pkg.globals$bllFlowContent.PopulatedVariableDetails <- "populatedVariableDetails"
pkg.globals$bllFlowContent.DDI <- "ddiList"
pkg.globals$bllFlowContent.LongTable <- "longTable"
pkg.globals$bllFlowContent.AdditionalMetaData <- "additionalDDIMetaData"
pkg.globals$bllFlowContent.WorkingData <- "workingData"

# MSW Column Names
pkg.globals$MSW.Variables.Columns.Variable <- "variable"
pkg.globals$MSW.Variables.Columns.VariableType <- "variableType"
pkg.globals$MSW.Variables.Columns.Label <- "label"
pkg.globals$MSW.Variables.Columns.LabelLong <- "labelLong"
pkg.globals$MSW.Variables.Columns.Units <- "units"

# Table one variable names
pkg.globals$tableOne.p75 <- "p75"
pkg.globals$tableOne.p25 <- "p25"
pkg.globals$tableOne.Miss <- "miss"
pkg.globals$tableOne.Mean <- "mean"
pkg.globals$tableOne.SD <- "sd"
pkg.globals$tableOne.Freq <- "freq"
pkg.globals$tableOne.Level <- "level"
pkg.globals$tableOne.Percent <- "percent"
pkg.globals$tableOne.StrataVarName <- "strataVarName"
pkg.globals$tableOne.N <- "n"
pkg.globals$tableOne.Vars <- "vars"

# Long table column names
pkg.globals$LongTable.VariableCategory <- "variableCategory"
pkg.globals$LongTable.VariableCategoryLabel <- "variableCategoryLabel"
pkg.globals$LongTable.Variable <- "variable"
pkg.globals$LongTable.Prevalence <- "prevalence"
pkg.globals$LongTable.Frequency <- "n"
pkg.globals$LongTable.NMissing <- "nMissing"
pkg.globals$LongTable.Mean <- "mean"
pkg.globals$LongTable.SD <- "sd"
pkg.globals$LongTable.Percentile25 <- "percentile25"
pkg.globals$LongTable.Percentile75 <- "percentile75"
pkg.globals$LongTable.GroupBy <- "groupBy"
pkg.globals$LongTable.GroupByValue <- "groupByValue"
pkg.globals$LongTable.GroupByLabel <- "groupByLabel"
pkg.globals$LongTable.GroupByValueLabel <- "groupByValueLabel"
pkg.globals$LongTable.ClassName <- "LongTable"
pkg.globals$LongTable.MetaData <- "MetaData"
pkg.globals$LongTable.SmallCells <- "smallCells"
pkg.globals$LongTable.LongTable <- "summaryData"

# Module Column names
pkg.globals$Modules.DefaultOrder <- "DefaultOrder"

# WorkingData contents
pkg.globals$WorkingData.ModuleSequenceNumber <- "moduleSequenceNumber"
pkg.globals$WorkingData.ModuleOperations <- "ModuleOperations"

# FunctionList contents
pkg.globals$FunctionList.Arguments <- "arguments"
pkg.globals$FunctionList.VariableArguments <- "variablesArguments"
