% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkData.R
\name{checkData}
\alias{checkData}
\title{Subsidiary Function for Comparative Causal Mediation Analysis}
\usage{
checkData(Y,T1,T2,M,data = NULL)
}
\arguments{
\item{Y}{numeric outcome variable. Should be a vector if a data frame is not provided through the \code{data} argument, or the ("character") name of the variable in the data frame if provided.}

\item{T1}{binary indicator for first treatment. Should be a vector if a data frame is not provided through the \code{data} argument, or the ("character") name of the variable in the data frame if provided.}

\item{T2}{binary indicator for second treatment. Should be a vector if a data frame is not provided through the \code{data} argument, or the ("character") name of the variable in the data frame if provided.}

\item{M}{numeric mediator variable. Should be a vector if a data frame is not provided through the \code{data} argument, or the ("character") name of the variable in the data frame if provided.}

\item{data}{an optional data frame containing the variables to be used in analysis.}
}
\value{
A data frame that contains the final data to be analyzed in the \code{getCCM()} function.
}
\description{
Subsidiary function to check correctness of data structure and return final data for analysis
}
\note{
This function is called internally but may be used directly to recover final data set that can be used for analysis in the \code{getCCM()} function.
}
\examples{
data(ICAapp)
final.dat <- checkData(Y = "dapprp", T1 = "trt1", T2 = "trt2", M = "immorp", data = ICAapp)
}
\references{
Bansak, K. (2020). Comparative causal mediation and relaxing the assumption of no mediator-outcome confounding: An application to international law and audience costs. Political Analysis, 28(2), 222-243.
}
\author{
Kirk Bansak and Xiaohan Wu
}
