% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOutbreakAttribute.R
\name{getOutbreakAttribute}
\alias{getOutbreakAttribute}
\title{Get attributes related to an outbreak}
\usage{
getOutbreakAttribute(attribute, outbreak)
}
\arguments{
\item{attribute}{Character scalar. Names the CCM object to
obtain related information about a case. One of the
currently supported objects:
\enumerate{
\item \code{exposures}
\item \code{investigations}
\item \code{locations}
}}

\item{outbreak}{Character scalar or vector. Names the Outbreak Id
to use when obtaining information.}
}
\value{
A \code{tibble} of information related to an Outbreak.
}
\description{
\code{getOutbreakAttribute()} specifies the object used to
get related information about an outbreak. This function
wraps \code{getAttribute()} to allow iteration over multiple
outbreaks.
}
\seealso{
\code{\link[=getAttribute]{getAttribute()}} for information on how the CCM
query is executed. \code{\link[=getOutbreaks]{getOutbreaks()}} for obtaining Outbreak Ids
required for this function.
}
