% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfa_equivalence.R
\name{equival}
\alias{equival}
\title{One-step equivalence testing
The function allows for a simple one step test of configural, metric, and
scalar equivalence between multiple groups.}
\usage{
equival(x, dat, group, standart_lv = TRUE, orthog = TRUE, estim = "MLM")
}
\arguments{
\item{x}{CFA model identical to models provided to lavaan.}

\item{dat}{A data frame or tibble containing the raw data for the
specified model.}

\item{group}{A character string that indicates the column of dat that contains
the grouping variable. e.g "country"}

\item{standart_lv}{A boolean that indicates whether the latent variables
should be standardised.}

\item{orthog}{A boolean that indicates whether the latent variables
should be orthogonal.}

\item{estim}{A string indicating the estimator to be used MLM for complete data and MLR for incomplete data. Defaults to MLM}
}
\value{
Returns a data frame with the fit indices for each model and delta
values comparing the different levels of equivalence. \href{https://www.frontiersin.org/articles/10.3389/fpsyg.2019.01507/full}{For a step by step interpretation see}.
}
\description{
One-step equivalence testing
The function allows for a simple one step test of configural, metric, and
scalar equivalence between multiple groups.
}
\examples{
\donttest{
model <- "voice =~ voice1m + voice2m + voice3m
          help =~ help1m + help2m + help3m"
equival(x = model, dat = example, group = "country")
}
}
