% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.r
\name{cdec_query_group}
\alias{cdec_query_group}
\title{Query CDEC Group}
\usage{
cdec_query_group(groups, start.date, end.date, ...)
}
\arguments{
\item{groups}{A vector of group codes.}

\item{start.date}{The start date of the query.}

\item{end.date}{The end date of the query.}

\item{...}{Not used.}
}
\value{
A tibble.
}
\description{
Query group data from the CDEC web services.
}
\details{
Note that CDEC timestamps are in Pacific Time and
Daylight Savings adjustments are reflected. In R, this is
equivalent to the timezone "US/Pacific".
}
\examples{
if(interactive()){
  cdec_query_group("SR1", Sys.Date() - 5, Sys.Date())
}

}
