% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energetics.R
\name{energetics_lme_summary}
\alias{energetics_lme_summary}
\title{Get mean and confidence intervals from energetics mixed-effects models}
\usage{
energetics_lme_summary(atp_col, energetics, conf_int, ci_method)
}
\arguments{
\item{atp_col}{The column name of the ATP measure - one of "ATP_basal_resp",
"ATP_max_resp", "ATP_basal_glyc", "ATP_max_glyc"}

\item{energetics}{a data.table of Seahorse OCR and ECAR rates (from \code{get_energetics})}

\item{conf_int}{The confidence interval percentage. Should be between 0 and
1}

\item{ci_method}{The method used to compute confidence intervals for the
mixed-effects model: \code{"Wald"}, \code{"profile"}, or \code{"boot"} passed to
\code{lme4::confint.merMod()}.}
}
\value{
a data.table with mean and the confidence interval bounds by
experimental group
}
\description{
Runs linear mixed-effects models on the ATP measure columns from
\code{get_energetics} with replicates as the random-effect. Estimates mean and
confidence intervals for ATP production from glycolysis and OXPHOS at points
defined in \code{partition_data}
}
\examples{
rep_list <- system.file("extdata", package = "ceas") |>
  list.files(pattern = "*.xlsx", full.names = TRUE)
seahorse_rates <- read_data(rep_list, sheet = 2)
partitioned_data <- partition_data(seahorse_rates)
energetics <- get_energetics(
  partitioned_data,
  ph = 7.4,
  pka = 6.093,
  buffer = 0.1
)
# Only for one column. For the full energetics table run
# `get_energetics_summary` with `model = "mixed"`.
energetics_lme_summary(
  "ATP_max_resp",
  energetics,
  conf_int = 0.95,
  ci_method = "Wald"
)
}
