% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw.R
\name{wbw}
\alias{wbw}
\title{Function to select the bandwidth parameter needed for smoothing the time-dependent ROC curve.}
\usage{
wbw(X, wt, bw = "NR", ktype = "normal")
}
\arguments{
\item{X}{The numeric data vector.}

\item{wt}{The non-negative weight vector.}

\item{bw}{A character string specifying the bandwidth selection method. The possible options are "\code{NR}" for the normal reference, the plug-in "\code{PI}" and cross-validation "\code{CV}".}

\item{ktype}{A character string indicating the type of kernel function: "\code{normal}", "\code{epanechnikov}", "\code{biweight}", or "\code{triweight}". Default is "\code{normal}" kernel.}
}
\value{
Returns the estimated value for the bandwith parameter.
}
\description{
This function computes the data-driven bandwidth value for smoothing the ROC curve.
             It contains three methods: the normal refrence, the plug-in and the cross-validation methods.
}
\references{
Beyene, K. M. and El Ghouch A. (2020). Smoothed time-dependent receiver operating characteristic curve for right censored survival data. \emph{Statistics in Medicine}. 39: 3373– 3396.
}
\author{
Kassu Mehari Beyene and Anouar El Ghouch
}
\keyword{internal}
