% Generated by roxygen2 (4.0.2): do not edit by hand
\name{katzcent}
\alias{katzcent}
\title{Find the Katz centrality (Katz Status Index)}
\usage{
katzcent(graph, vids = V(graph), alpha = 0.1)
}
\arguments{
\item{graph}{The input graph as igraph object}

\item{vids}{Vertex sequence, the vertices for which the centrality values are returned. Default is all vertices.}

\item{alpha}{The alpha parameter, which must be between 0.0-0.2. The default is 0.1.}
}
\value{
A numeric vector contaning the centrality scores for the selected vertices.
}
\description{
The Katz centrality for node i is:
\deqn{x_{i}=\alpha \sum_{j}A_{ij}x_{j}+\beta}{x(i)=alpha * sum(A(ij)*x(j), j) + beta}
where \eqn{A}{A} is the adjacency matrix of the graph G with eigenvalues \eqn{\lambda}{lambda}. The parameter \eqn{\beta}{beta} controls the initial centrality and \eqn{\alpha < \frac{1}{\lambda_{max}}}{alpha < 1/lambda(max)}.
}
\details{
Katz centrality computes the relative influence of a node within a network by measuring the number of the immediate neighbors (first degree nodes) and also all other nodes in the network that connect to the node under consideration through these immediate neighbors. \cr
More detail at \href{http://www.centiserver.org/?q1=centrality&q2=Katz_Centrality}{Katz Centrality}
}
\examples{
g <- barabasi.game(20)
katzcent(g)
}
\author{
Mahdi Jalili \email{m_jalili@farabi.tums.ac.ir}

Algorithm adapted from CentiBin with thanks Dirk Koschutzki. (Junker, Bjorn H. 2006).
}
\references{
Newman, Mark. Networks: an introduction. Oxford University Press, 2010.

Junker, Bjorn H., Dirk Koschutzki, and Falk Schreiber. "Exploration of biological network centralities with CentiBiN." BMC bioinformatics 7.1 (2006): 219.
}

