% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_ratings.R
\name{cfbd_ratings_fpi}
\alias{cfbd_ratings_fpi}
\title{\strong{Get Football Power Index (FPI) historical rating data}}
\usage{
cfbd_ratings_fpi(year = NULL, team = NULL, conference = NULL)
}
\arguments{
\item{year}{(\emph{Integer} optional): Year, 4 digit format (\emph{YYYY}). Required if team not provided}

\item{team}{(\emph{String} optional): D-I Team. Required if year not provided}

\item{conference}{(\emph{String} optional): Conference name - select a valid FBS conference
Conference names P5: ACC,  Big 12, Big Ten, SEC, Pac-12
Conference names G5 and FBS Independents: Conference USA, Mid-American, Mountain West, FBS Independents, American Athletic}
}
\value{
\code{\link[=cfbd_ratings_fpi]{cfbd_ratings_fpi()}} - A data frame with 14 variables:\tabular{ll}{
   col_name \tab types \cr
   year \tab integer \cr
   team \tab character \cr
   conference \tab character \cr
   fpi \tab numeric \cr
   resume_ranks_strength_of_record \tab integer \cr
   resume_ranks_fpi \tab integer \cr
   resume_ranks_average_win_probability \tab integer \cr
   resume_ranks_strength_of_schedule \tab integer \cr
   resume_ranks_remaining_strength_of_schedule \tab integer \cr
   resume_ranks_game_control \tab integer \cr
   efficiencies_overall \tab numeric \cr
   efficiencies_offense \tab numeric \cr
   efficiencies_defense \tab numeric \cr
   efficiencies_special_teams \tab numeric \cr
}
}
\description{
Acquire the ESPN calculated FPI ratings data by team, year, and conference
}
\examples{
\donttest{
  try(cfbd_ratings_fpi(year = 2019, team = "Texas"))

  try(cfbd_ratings_fpi(year = 2018, conference = "SEC"))
}

}
\seealso{
Other CFBD Ratings and Rankings: 
\code{\link{cfbd_rankings}()},
\code{\link{cfbd_ratings_elo}()},
\code{\link{cfbd_ratings_sp}()},
\code{\link{cfbd_ratings_sp_conference}()},
\code{\link{cfbd_ratings_srs}()}
}
\concept{CFBD Ratings and Rankings}
\keyword{FPI}
\keyword{Ratings}
