% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_ratings.R
\name{cfbd_ratings_sp_conference}
\alias{cfbd_ratings_sp_conference}
\title{\strong{Get conference level SP historical rating data}}
\usage{
cfbd_ratings_sp_conference(year = NULL, conference = NULL)
}
\arguments{
\item{year}{(\emph{Integer} optional): Year, 4 digit format (\emph{YYYY})}

\item{conference}{(\emph{String} optional): Conference abbreviation - S&P+ information by conference
Conference abbreviations P5: ACC, B12, B1G, SEC, PAC
Conference abbreviations G5 and FBS Independents: CUSA, MAC, MWC, Ind, SBC, AAC}
}
\value{
\code{\link[=cfbd_ratings_sp_conference]{cfbd_ratings_sp_conference()}} - A data frame with 25 variables:
\describe{
\item{\code{year}: integer.}{Season of the conference rating.}
\item{\code{conference}: character.}{Conference name.}
\item{\code{rating}: double.}{Conference SP+ rating.}
\item{\code{second_order_wins}: logical.}{Second-order wins for the conference - Not available for recent seasons.}
\item{\code{sos}: logical.}{Strength of schedule for the conference  - Not available for recent seasons..}
\item{\code{offense_rating}: double.}{Overall offense rating for the conference.}
\item{\code{offense_success}: logical.}{Offense success rating for the conference - Not available for recent seasons.}
\item{\code{offense_explosiveness}: logical.}{Offense explosiveness rating for the conference - Not available for recent seasons.}
\item{\code{offense_rushing}: logical.}{Offense rushing rating for the conference - Not available for recent seasons.}
\item{\code{offense_passing}: logical.}{Offense passing rating for the conference - Not available for recent seasons.}
\item{\code{offense_standard_downs}: logical.}{Offense standard downs rating for the conference - Not available for recent seasons.}
\item{\code{offense_passing_downs}: logical.}{Offensive passing downs rating for the conference - Not available for recent seasons.}
\item{\code{offense_run_rate}: logical.}{Offense rushing rate for the conference - Not available for recent seasons.}
\item{\code{offense_pace}: logical.}{Offense pace factor for the conference - Not available for recent seasons.}
\item{\code{defense_ranking}: integer.}{Overall defense ranking for the conference.}
\item{\code{defense_rating}: double.}{Overall defense rating for the conference.}
\item{\code{defense_success}: logical.}{Defense success rating for the conference - Not available for recent seasons.}
\item{\code{defense_explosiveness}: logical.}{Defense explosiveness rating for the conference - Not available for recent seasons.}
\item{\code{defense_rushing}: logical.}{Defense rushing rating for the conference - Not available for recent seasons.}
\item{\code{defense_passing}: logical.}{Defense passing rating for the conference - Not available for recent seasons.}
\item{\code{defense_standard_downs}: logical.}{Defense standard downs rating for the conference - Not available for recent seasons.}
\item{\code{defense_passing_downs}: logical.}{Defensive passing downs rating for the conference - Not available for recent seasons.}
\item{\code{defense_havoc_total}: logical.}{Total defensive havoc rate for the conference - Not available for recent seasons.}
\item{\code{defense_havoc_front_seven}: logical.}{Defense havoc rate from front 7 players for the conference - Not available for recent seasons.}
\item{\code{defense_havoc_db}: logical.}{Defense havoc rate from defensive backs for the conference - Not available for recent seasons.}
\item{\code{special_teams_rating}: double.}{Special teams rating for the conference.}
}
}
\description{
\strong{Get conference level SP historical rating data}
}
\examples{
\donttest{
  try(cfbd_ratings_sp_conference(year = 2019))

  try(cfbd_ratings_sp_conference(year = 2012, conference = "SEC"))

  try(cfbd_ratings_sp_conference(year = 2016, conference = "ACC"))
}

}
\seealso{
Other CFBD Ratings and Rankings: 
\code{\link{cfbd_rankings}()},
\code{\link{cfbd_ratings_elo}()},
\code{\link{cfbd_ratings_fpi}()},
\code{\link{cfbd_ratings_sp}()},
\code{\link{cfbd_ratings_srs}()}
}
\concept{CFBD Ratings and Rankings}
\keyword{Conference}
\keyword{SP+}
