% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_teams.R
\name{cfbd_team_talent}
\alias{cfbd_team_talent}
\title{\strong{Get composite team talent rankings for all teams in a given year}}
\usage{
cfbd_team_talent(year = most_recent_cfb_season())
}
\arguments{
\item{year}{(\emph{Integer} optional): Year 4 digit format (\emph{YYYY})}
}
\value{
\code{\link[=cfbd_team_talent]{cfbd_team_talent()}} - A data frame with 3 variables:
\describe{
\item{\code{year}: integer.}{Season for the talent rating.}
\item{\code{school}: character.}{Team name.}
\item{\code{talent}: double.}{Overall roster talent points (as determined by 247Sports).}
}
}
\description{
Extracts team talent composite as sourced from 247 rankings
}
\examples{
\donttest{
  try(cfbd_team_talent())

  try(cfbd_team_talent(year = 2018))
}

}
\seealso{
Other CFBD Teams: 
\code{\link{cfbd_team_info}()},
\code{\link{cfbd_team_matchup}()},
\code{\link{cfbd_team_matchup_records}()},
\code{\link{cfbd_team_roster}()}
}
\concept{CFBD Teams}
\keyword{Team}
\keyword{talent}
