% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/espn_cfb_team_stats.R
\name{espn_cfb_team_stats}
\alias{espn_cfb_team_stats}
\title{\strong{Get ESPN college football team stats data}}
\usage{
espn_cfb_team_stats(team_id, year, season_type = "regular", total = FALSE)
}
\arguments{
\item{team_id}{Team ID}

\item{year}{Year}

\item{season_type}{(character, default: regular): Season type - regular or postseason}

\item{total}{(boolean, default: FALSE): Totals}
}
\value{
Returns a tibble with the following columns:\tabular{ll}{
   col_name \tab types \cr
   team_id \tab character \cr
   team_guid \tab character \cr
   team_uid \tab character \cr
   team_sdr \tab character \cr
   team_slug \tab character \cr
   team_location \tab character \cr
   team_name \tab character \cr
   team_nickname \tab character \cr
   team_abbreviation \tab character \cr
   team_display_name \tab character \cr
   team_short_display_name \tab character \cr
   team_color \tab character \cr
   team_alternate_color \tab character \cr
   is_active \tab logical \cr
   is_all_star \tab logical \cr
   logo_href \tab character \cr
   logo_dark_href \tab character \cr
   general_fumbles \tab numeric \cr
   general_fumbles_lost \tab numeric \cr
   general_fumbles_forced \tab numeric \cr
   general_fumbles_recovered \tab numeric \cr
   general_fumbles_touchdowns \tab numeric \cr
   general_games_played \tab numeric \cr
   general_offensive_two_pt_returns \tab numeric \cr
   general_offensive_fumbles_touchdowns \tab numeric \cr
   general_defensive_fumbles_touchdowns \tab numeric \cr
   passing_avg_gain \tab numeric \cr
   passing_completion_pct \tab numeric \cr
   passing_completions \tab numeric \cr
   passing_espnqb_rating \tab numeric \cr
   passing_interception_pct \tab numeric \cr
   passing_interceptions \tab numeric \cr
   passing_long_passing \tab numeric \cr
   passing_misc_yards \tab numeric \cr
   passing_net_passing_yards \tab numeric \cr
   passing_net_passing_yards_per_game \tab numeric \cr
   passing_net_total_yards \tab numeric \cr
   passing_net_yards_per_game \tab numeric \cr
   passing_passing_attempts \tab numeric \cr
   passing_passing_big_plays \tab numeric \cr
   passing_passing_first_downs \tab numeric \cr
   passing_passing_fumbles \tab numeric \cr
   passing_passing_fumbles_lost \tab numeric \cr
   passing_passing_touchdown_pct \tab numeric \cr
   passing_passing_touchdowns \tab numeric \cr
   passing_passing_yards \tab numeric \cr
   passing_passing_yards_after_catch \tab numeric \cr
   passing_passing_yards_at_catch \tab numeric \cr
   passing_passing_yards_per_game \tab numeric \cr
   passing_qb_rating \tab numeric \cr
   passing_sacks \tab numeric \cr
   passing_sack_yards_lost \tab numeric \cr
   passing_team_games_played \tab numeric \cr
   passing_total_offensive_plays \tab numeric \cr
   passing_total_points \tab numeric \cr
   passing_total_points_per_game \tab numeric \cr
   passing_total_touchdowns \tab numeric \cr
   passing_total_yards \tab numeric \cr
   passing_total_yards_from_scrimmage \tab numeric \cr
   passing_two_point_pass_convs \tab numeric \cr
   passing_two_pt_pass \tab numeric \cr
   passing_two_pt_pass_attempts \tab numeric \cr
   passing_yards_from_scrimmage_per_game \tab numeric \cr
   passing_yards_per_completion \tab numeric \cr
   passing_yards_per_game \tab numeric \cr
   passing_yards_per_pass_attempt \tab numeric \cr
   passing_net_yards_per_pass_attempt \tab numeric \cr
   passing_quarterback_rating \tab numeric \cr
   rushing_avg_gain \tab numeric \cr
   rushing_espnrb_rating \tab numeric \cr
   rushing_long_rushing \tab numeric \cr
   rushing_misc_yards \tab numeric \cr
   rushing_net_total_yards \tab numeric \cr
   rushing_net_yards_per_game \tab numeric \cr
   rushing_rushing_attempts \tab numeric \cr
   rushing_rushing_big_plays \tab numeric \cr
   rushing_rushing_first_downs \tab numeric \cr
   rushing_rushing_fumbles \tab numeric \cr
   rushing_rushing_fumbles_lost \tab numeric \cr
   rushing_rushing_touchdowns \tab numeric \cr
   rushing_rushing_yards \tab numeric \cr
   rushing_rushing_yards_per_game \tab numeric \cr
   rushing_stuffs \tab numeric \cr
   rushing_stuff_yards_lost \tab numeric \cr
   rushing_team_games_played \tab numeric \cr
   rushing_total_offensive_plays \tab numeric \cr
   rushing_total_points \tab numeric \cr
   rushing_total_points_per_game \tab numeric \cr
   rushing_total_touchdowns \tab numeric \cr
   rushing_total_yards \tab numeric \cr
   rushing_total_yards_from_scrimmage \tab numeric \cr
   rushing_two_point_rush_convs \tab numeric \cr
   rushing_two_pt_rush \tab numeric \cr
   rushing_two_pt_rush_attempts \tab numeric \cr
   rushing_yards_from_scrimmage_per_game \tab numeric \cr
   rushing_yards_per_game \tab numeric \cr
   rushing_yards_per_rush_attempt \tab numeric \cr
   receiving_avg_gain \tab numeric \cr
   receiving_espnwr_rating \tab numeric \cr
   receiving_long_reception \tab numeric \cr
   receiving_misc_yards \tab numeric \cr
   receiving_net_total_yards \tab numeric \cr
   receiving_net_yards_per_game \tab numeric \cr
   receiving_receiving_big_plays \tab numeric \cr
   receiving_receiving_first_downs \tab numeric \cr
   receiving_receiving_fumbles \tab numeric \cr
   receiving_receiving_fumbles_lost \tab numeric \cr
   receiving_receiving_targets \tab numeric \cr
   receiving_receiving_touchdowns \tab numeric \cr
   receiving_receiving_yards \tab numeric \cr
   receiving_receiving_yards_after_catch \tab numeric \cr
   receiving_receiving_yards_at_catch \tab numeric \cr
   receiving_receiving_yards_per_game \tab numeric \cr
   receiving_receptions \tab numeric \cr
   receiving_team_games_played \tab numeric \cr
   receiving_total_offensive_plays \tab numeric \cr
   receiving_total_points \tab numeric \cr
   receiving_total_points_per_game \tab numeric \cr
   receiving_total_touchdowns \tab numeric \cr
   receiving_total_yards \tab numeric \cr
   receiving_total_yards_from_scrimmage \tab numeric \cr
   receiving_two_point_rec_convs \tab numeric \cr
   receiving_two_pt_reception \tab numeric \cr
   receiving_two_pt_reception_attempts \tab numeric \cr
   receiving_yards_from_scrimmage_per_game \tab numeric \cr
   receiving_yards_per_game \tab numeric \cr
   receiving_yards_per_reception \tab numeric \cr
   defensive_assist_tackles \tab numeric \cr
   defensive_avg_interception_yards \tab numeric \cr
   defensive_avg_sack_yards \tab numeric \cr
   defensive_avg_stuff_yards \tab numeric \cr
   defensive_blocked_field_goal_touchdowns \tab numeric \cr
   defensive_blocked_punt_touchdowns \tab numeric \cr
   defensive_defensive_touchdowns \tab numeric \cr
   defensive_hurries \tab numeric \cr
   defensive_kicks_blocked \tab numeric \cr
   defensive_long_interception \tab numeric \cr
   defensive_misc_touchdowns \tab numeric \cr
   defensive_passes_batted_down \tab numeric \cr
   defensive_passes_defended \tab numeric \cr
   defensive_two_pt_returns \tab numeric \cr
   defensive_sacks \tab numeric \cr
   defensive_sack_yards \tab numeric \cr
   defensive_safeties \tab numeric \cr
   defensive_solo_tackles \tab numeric \cr
   defensive_stuffs \tab numeric \cr
   defensive_stuff_yards \tab numeric \cr
   defensive_tackles_for_loss \tab numeric \cr
   defensive_team_games_played \tab numeric \cr
   defensive_total_tackles \tab numeric \cr
   defensive_yards_allowed \tab numeric \cr
   defensive_points_allowed \tab numeric \cr
   defensive_one_pt_safeties_made \tab numeric \cr
   defensive_interceptions_interceptions \tab numeric \cr
   defensive_interceptions_interception_touchdowns \tab numeric \cr
   defensive_interceptions_interception_yards \tab numeric \cr
   kicking_avg_kickoff_return_yards \tab numeric \cr
   kicking_avg_kickoff_yards \tab numeric \cr
   kicking_extra_point_attempts \tab numeric \cr
   kicking_extra_point_pct \tab numeric \cr
   kicking_extra_points_blocked \tab numeric \cr
   kicking_extra_points_blocked_pct \tab numeric \cr
   kicking_extra_points_made \tab numeric \cr
   kicking_fair_catches \tab numeric \cr
   kicking_fair_catch_pct \tab numeric \cr
   kicking_field_goal_attempts \tab numeric \cr
   kicking_field_goal_attempts1_19 \tab numeric \cr
   kicking_field_goal_attempts20_29 \tab numeric \cr
   kicking_field_goal_attempts30_39 \tab numeric \cr
   kicking_field_goal_attempts40_49 \tab numeric \cr
   kicking_field_goal_attempts50_59 \tab numeric \cr
   kicking_field_goal_attempts60_99 \tab numeric \cr
   kicking_field_goal_attempts50 \tab numeric \cr
   kicking_field_goal_attempt_yards \tab numeric \cr
   kicking_field_goal_pct \tab numeric \cr
   kicking_field_goals_blocked \tab numeric \cr
   kicking_field_goals_blocked_pct \tab numeric \cr
   kicking_field_goals_made \tab numeric \cr
   kicking_field_goals_made1_19 \tab numeric \cr
   kicking_field_goals_made20_29 \tab numeric \cr
   kicking_field_goals_made30_39 \tab numeric \cr
   kicking_field_goals_made40_49 \tab numeric \cr
   kicking_field_goals_made50_59 \tab numeric \cr
   kicking_field_goals_made60_99 \tab numeric \cr
   kicking_field_goals_made50 \tab numeric \cr
   kicking_field_goals_made_yards \tab numeric \cr
   kicking_field_goals_missed_yards \tab numeric \cr
   kicking_kickoff_returns \tab numeric \cr
   kicking_kickoff_return_touchdowns \tab numeric \cr
   kicking_kickoff_return_yards \tab numeric \cr
   kicking_kickoffs \tab numeric \cr
   kicking_kickoff_yards \tab numeric \cr
   kicking_long_field_goal_attempt \tab numeric \cr
   kicking_long_field_goal_made \tab numeric \cr
   kicking_long_kickoff \tab numeric \cr
   kicking_team_games_played \tab numeric \cr
   kicking_total_kicking_points \tab numeric \cr
   kicking_touchback_pct \tab numeric \cr
   kicking_touchbacks \tab numeric \cr
   returning_def_fumble_returns \tab numeric \cr
   returning_def_fumble_return_yards \tab numeric \cr
   returning_fumble_recoveries \tab numeric \cr
   returning_fumble_recovery_yards \tab numeric \cr
   returning_kick_return_fair_catches \tab numeric \cr
   returning_kick_return_fair_catch_pct \tab numeric \cr
   returning_kick_return_fumbles \tab numeric \cr
   returning_kick_return_fumbles_lost \tab numeric \cr
   returning_kick_returns \tab numeric \cr
   returning_kick_return_touchdowns \tab numeric \cr
   returning_kick_return_yards \tab numeric \cr
   returning_long_kick_return \tab numeric \cr
   returning_long_punt_return \tab numeric \cr
   returning_misc_fumble_returns \tab numeric \cr
   returning_misc_fumble_return_yards \tab numeric \cr
   returning_opp_fumble_recoveries \tab numeric \cr
   returning_opp_fumble_recovery_yards \tab numeric \cr
   returning_opp_special_team_fumble_returns \tab numeric \cr
   returning_opp_special_team_fumble_return_yards \tab numeric \cr
   returning_punt_return_fair_catches \tab numeric \cr
   returning_punt_return_fair_catch_pct \tab numeric \cr
   returning_punt_return_fumbles \tab numeric \cr
   returning_punt_return_fumbles_lost \tab numeric \cr
   returning_punt_returns \tab numeric \cr
   returning_punt_returns_started_inside_the10 \tab numeric \cr
   returning_punt_returns_started_inside_the20 \tab numeric \cr
   returning_punt_return_touchdowns \tab numeric \cr
   returning_punt_return_yards \tab numeric \cr
   returning_special_team_fumble_returns \tab numeric \cr
   returning_special_team_fumble_return_yards \tab numeric \cr
   returning_team_games_played \tab numeric \cr
   returning_yards_per_kick_return \tab numeric \cr
   returning_yards_per_punt_return \tab numeric \cr
   returning_yards_per_return \tab numeric \cr
   punting_avg_punt_return_yards \tab numeric \cr
   punting_fair_catches \tab numeric \cr
   punting_gross_avg_punt_yards \tab numeric \cr
   punting_long_punt \tab numeric \cr
   punting_net_avg_punt_yards \tab numeric \cr
   punting_punt_returns \tab numeric \cr
   punting_punt_return_yards \tab numeric \cr
   punting_punts \tab numeric \cr
   punting_punts_blocked \tab numeric \cr
   punting_punts_blocked_pct \tab numeric \cr
   punting_punts_inside10 \tab numeric \cr
   punting_punts_inside10pct \tab numeric \cr
   punting_punts_inside20 \tab numeric \cr
   punting_punts_inside20pct \tab numeric \cr
   punting_punt_yards \tab numeric \cr
   punting_team_games_played \tab numeric \cr
   punting_touchback_pct \tab numeric \cr
   punting_touchbacks \tab numeric \cr
   scoring_defensive_points \tab numeric \cr
   scoring_field_goals \tab numeric \cr
   scoring_kick_extra_points \tab numeric \cr
   scoring_misc_points \tab numeric \cr
   scoring_passing_touchdowns \tab numeric \cr
   scoring_receiving_touchdowns \tab numeric \cr
   scoring_return_touchdowns \tab numeric \cr
   scoring_rushing_touchdowns \tab numeric \cr
   scoring_total_points \tab numeric \cr
   scoring_total_points_per_game \tab numeric \cr
   scoring_total_touchdowns \tab numeric \cr
   scoring_total_two_point_convs \tab numeric \cr
   scoring_two_point_pass_convs \tab numeric \cr
   scoring_two_point_rec_convs \tab numeric \cr
   scoring_two_point_rush_convs \tab numeric \cr
   scoring_one_pt_safeties_made \tab numeric \cr
   miscellaneous_first_downs \tab numeric \cr
   miscellaneous_first_downs_passing \tab numeric \cr
   miscellaneous_first_downs_penalty \tab numeric \cr
   miscellaneous_first_downs_per_game \tab numeric \cr
   miscellaneous_first_downs_rushing \tab numeric \cr
   miscellaneous_fourth_down_attempts \tab numeric \cr
   miscellaneous_fourth_down_conv_pct \tab numeric \cr
   miscellaneous_fourth_down_convs \tab numeric \cr
   miscellaneous_fumbles_lost \tab numeric \cr
   miscellaneous_possession_time_seconds \tab numeric \cr
   miscellaneous_redzone_efficiency_pct \tab numeric \cr
   miscellaneous_redzone_field_goal_pct \tab numeric \cr
   miscellaneous_redzone_scoring_pct \tab numeric \cr
   miscellaneous_redzone_touchdown_pct \tab numeric \cr
   miscellaneous_third_down_attempts \tab numeric \cr
   miscellaneous_third_down_conv_pct \tab numeric \cr
   miscellaneous_third_down_convs \tab numeric \cr
   miscellaneous_total_giveaways \tab numeric \cr
   miscellaneous_total_penalties \tab numeric \cr
   miscellaneous_total_penalty_yards \tab numeric \cr
   miscellaneous_total_takeaways \tab numeric \cr
   miscellaneous_total_drives \tab numeric \cr
   miscellaneous_turn_over_differential \tab numeric \cr
}
}
\description{
\strong{Get ESPN college football team stats data}
}
\examples{
\donttest{
  try(espn_cfb_team_stats(team_id = 52, year = 2020))
}

}
\author{
Saiem Gilani
}
\keyword{CFB}
\keyword{Stats}
\keyword{Team}
