% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_point_firehose.R
\name{single_point_firehose}
\alias{single_point_firehose}
\title{Single point firehose}
\usage{
single_point_firehose(
  input_variables,
  lat,
  lon,
  web_link = "https://cida.usgs.gov/thredds/dodsC/macav2metdata_daily_future",
  verbose = FALSE
)
}
\arguments{
\item{input_variables}{Table of specifications for requested dataset: model type, date range, variables (list)}

\item{lat}{Latitude specifications for area of interest (list)}

\item{lon}{Longitude specifications for area of interest (list)}

\item{web_link}{A web link to the api data source you want to read (character)}

\item{verbose}{If True detailed processing information will be output (logical)}
}
\value{
Data.frame of requested data
}
\description{
Using the default web link, this package retrieves daily gridded data sets of General Circulation Model
(GCM) runs clipped to areas of interest and returns a data frame of the
file names and they're storage paths. Each of these data sets represent
a single GCM, climate variable and Representative Concentration Pathway (RCP)
from 1950 to 2099. The 1950 to 2005 portion of this time period represents
historical data while the 2006 to 2099 portion represents modeled data. 
The original data sets may be found at
\url{http://thredds.northwestknowledge.net:8080/thredds/reacch_climate_CMIP5_aggregated_macav2_catalog.html}
}
